package com.elitesland.yst.production.sale.dto.save;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.io.Serializable;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/9/15 11:47
 */
@ApiModel(description = "客户信息")
@Data
public class ComSaleFileComDto implements Serializable {

    private static final long serialVersionUID = 7947570905241967968L;

    /**
     * 证件编号
     */
    private String qualifyNo;

    /**
     * 业务关联ID
     */
    private Long businessId;

    /**
     * 业务类型
     */
    private String businessType;

    /**
     * 文件ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    private Long fileId;

    /**
     * 文件名称
     */
    private String originalName;

    /**
     * 文件编号
     */
    private String fileCode;

    /**
     * 文件类型(图片，附件等)
     */
    private String fileType;

    /**
     * 图片尺寸
     */
    private String imgSize;

    /**
     * 文件大小
     */
    private String fileSize;

    /**
     * 是否主图
     */
    private Boolean major;

    /**
     * 附件备注
     */
    private String remark;
}
