package com.elitesland.yst.production.sale.dto.save;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author Danny.Wang
 * @title SalesmanUpdateDTO
 * @Date2023/3/2 10:45
 */
@Data
@ApiModel("业务员数据更新参数")
public class SalesmanUpdateDTO implements Serializable {

    /**
     * 业务员id
     */
    @NotNull(message = "业务员id不允许为空")
    @ApiModelProperty("业务员id")
    private Long salesmanId;

    /**
     * 头像文件编码
     */
    @ApiModelProperty("头像文件编码")
    private String fileCode;

    /**
     * 手机号
     */
    @ApiModelProperty("手机号")
    private String phone;

}
