/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.api;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmtBigDecimalJsonDeserialize
extends JsonDeserializer<BigDecimal> {
    private static final Logger log = LoggerFactory.getLogger(AmtBigDecimalJsonDeserialize.class);

    public BigDecimal deserialize(JsonParser p, DeserializationContext deserializationContext) throws IOException {
        if (p.currentToken().isNumeric() || p.currentToken().id() == 6) {
            try {
                return new BigDecimal(p.getText()).setScale(2, RoundingMode.DOWN);
            }
            catch (NumberFormatException e) {
                log.info(e.getMessage());
                return BigDecimal.ZERO;
            }
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal getNullValue(DeserializationContext deserializationContext) {
        return BigDecimal.ZERO;
    }
}

