package com.elitesland.yst.production.sale.api;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonTokenId;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import lombok.extern.slf4j.Slf4j;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;

/**
 * <p>
 * 金额数据反序列化：
 * </p>
 *
 * @author ssy
 * @since 2021/8/19
 */
@Slf4j
public class AmtBigDecimalJsonDeserialize extends JsonDeserializer<BigDecimal> {

    @Override
    public BigDecimal deserialize(JsonParser p, DeserializationContext deserializationContext) throws IOException {
        //value类型是数值型或者是字符串类型，则转为bigDecimal
        if (p.currentToken().isNumeric() || p.currentToken().id() == JsonTokenId.ID_STRING) {
            try {
                return new BigDecimal(p.getText()).setScale(2, RoundingMode.DOWN);
            } catch (NumberFormatException e) {
                log.info(e.getMessage());
                return BigDecimal.ZERO;
            }
        }
        //其余情况一律返回0
        return BigDecimal.ZERO;
    }

    @Override
    public BigDecimal getNullValue(DeserializationContext deserializationContext) {
        //当对应的值类型为null时候，也返回0
        return BigDecimal.ZERO;
    }
}