package com.elitesland.yst.production.sale.api.service;

import com.alibaba.fastjson.JSONObject;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.vo.param.pro.SalAcceptancePagingParam;
import com.elitesland.yst.production.sale.api.vo.param.pro.SalAcceptanceSaveParam;
import com.elitesland.yst.production.sale.api.vo.resp.pro.SalAcceptanceDetailRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.pro.SalAcceptancePageRespVO;

/**
 * @author Eric.li (Li Jia Zhe)
 * @date 2021-06-21 09:52:24
 */
public interface SalAcceptanceService {

    /**
     * 根据查询条件分页查询项目验收列表
     * @param pageParam 查询条件
     * @return
     */
    PagingVO<SalAcceptancePageRespVO> query(SalAcceptancePagingParam pageParam);

    /**
     * 保存或提交验收单
     * @param param 参数
     * @return
     */
    JSONObject saveOrSubmit(SalAcceptanceSaveParam param, String operation);

    /**
     * 直接提交验收单
     * @param id 验收单ID
     * @return
     */
    void submitOne(Long id);

    /**
     * 删除合同验收单
     * @param id 验收单ID
     */
    void deleteAc(Long id);

    /**
     * 获取一个验收单详情
     * @param id 验收单ID
     * @return
     */
    SalAcceptanceDetailRespVO findOneDetail(Long id);

    /**
     * 审批验收单
     * @param id 验收单ID
     * @param apprStatus 审批状态
     */
    void apprAcc(Long id, String apprStatus);

}
