package com.elitesland.yst.production.sale.api.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.SysEmployeeBasicDTO;
import com.elitesland.yst.production.sale.api.vo.param.salesman.*;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmCustBaseRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.salesman.*;
import com.elitesland.yst.production.sale.api.vo.resp.salesman.SalesmanInfoStdVO;
import com.elitesland.yst.production.sale.api.vo.save.SalesmanInfoSaveVO;
import com.elitesland.yst.production.sale.dto.SalesmanInfoDTO;
import com.elitesland.yst.production.sale.dto.SalesmanLevelInfoDTO;
import com.elitesland.yst.production.sale.dto.query.SalesmanAPPQueryDTO;
import com.elitesland.yst.production.sale.dto.query.SalesmanInfoAPPRespDTO;
import com.elitesland.yst.production.sale.dto.query.SalesmanQueryDTO;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * @author Danny.Wang
 * @title SalesmanInfoService
 * @Date2023/2/21 16:07
 */
public interface SalesmanInfoService {

    ApiResult<Object> save(SalesmanInfoSaveVO salesmanInfoSaveVO);

    ApiResult<PagingVO<SalesmanInfoRespVO>> query(SalesmanInfoQueryVO salesmanInfoQueryVO);
    ApiResult<PagingVO<SalesmanInfoRespVO>> queryUser(SalesmanInfoQueryVO salesmanInfoQueryVO);

    ApiResult<SalesmanInfoDetailRespVO> queryDetail(Long id);


    SysEmployeeBasicDTO queryDetailByUserId(Long id);


    ApiResult<PagingVO<SalesmanInfoRespVO>> querySubordinate(SalesmanSubordinateQueryVO salesmanSubordinateQueryVO);

    ApiResult<Object> changeStatus(SalesmanInfoChangeVO salesmanInfoChangeVO);

    ApiResult<PagingVO<SalesmanSuperiorRespVO>> querySuperior(SalesmanSuperiorQueryVO salesmanSuperiorQueryVO);

    ApiResult<Object> salesmanImport(MultipartFile file);

    ApiResult<PagingVO<SalesmanDetailInfoRespVO>> querySalesmanAllInfo(SalesmanInfoQueryVO salesmanInfoQueryVO);

    SalesmanLevelInfoDTO queryLevelInfo(Long id);

    List<SalesmanInfoSimpleRespVO> simpleQuery(SalesmanInfoSimpleQueryVO param);

    SalesmanInfoAppDetailRespVO appQueryDetail(String code);

    ApiResult<SalesmanInfoDTO> querySalesmanInfo(SalesmanQueryDTO salesmanQueryDTO);

    ApiResult<List<SalesmanInfoAPPRespDTO>> salesmanTeam(SalesmanAPPQueryDTO salesmanAPPQueryDTO);

    PagingVO<SalesmanInfoAPPRespDTO> salesmanTeamAll(SalesmanAPPQueryDTO salesmanAPPQueryDTO);

    ApiResult<List<CrmCustBaseRespVO>> queryAllByAgentEmpIdAndSub(Long agentEmpId);

    PagingVO<SalesmanInfoStdVO> queryAllSalemanInfosByAgentEmpId(SalesmanUnderLingQueryVO salesmanUnderLingQueryVO);

}
