package com.elitesland.yst.production.sale.api.service.shop;

import com.elitesland.yst.production.sale.api.vo.param.shop.BipHelpCreateParam;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipHelpQueryParam;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipHelpCenterRespVO;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

/**
 * @author Joker (Xing Shixiang)
 * @create 2021-08-10 15:29
 */
public interface BipHelpCenterService {
    /**
     * 小程序-查全部未禁用的
     * @return 帮助列表
     */
    List<BipHelpCenterRespVO> appfindAll();

    /**
     * 小程序-根据id查详情
     * @param id 帮助文章id
     * @return 帮助文章
     */
    BipHelpCenterRespVO getHelpById(Long id);
    /**
     * 管理端-根据条件查全部
     * @param param param
     * @return 帮助列表
     */
    PagingVO<BipHelpCenterRespVO> findAll(BipHelpQueryParam param);
    /**
     * 管理端-根据条件查全部
     * @param id param
     * @param status --文档状态
     * @return 帮助列表
     */
    Long updateStatus(Long id , String status);
    /**
     * 管理端-根据条件查全部
     * @param id param
     * @param deleteFlag 删除标记  -0 未删除 -1 已删除
     * @return 帮助列表
     */
    Long updateDeleteFlag(Long id , Integer deleteFlag);
    /**
     * 管理端-根据条件查全部
     * @param param 删除标记  -0 未删除 -1 已删除
     * @return 帮助列表
     */
    Long saveHelp(BipHelpCreateParam param);
}
