package com.elitesland.yst.production.sale.api.service.shop;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipItemEvalParmVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipItemEvalRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.app.BipItemEvalAppRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.app.BipItemEvalDetailAppRespVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipItemEvalDetailSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipItemEvalSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipItemEvalSimpleSaveVO;

import java.math.BigDecimal;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/19/15:40
 * @Description:
 */
public interface BipItemEvalService {

    /**
     * 分页查询
     * @param bipItemEvalParmVO
     * @return
     */
     PagingVO<BipItemEvalRespVO> findItemEvalPage(BipItemEvalParmVO bipItemEvalParmVO);

    /**
     * app 分页查询
     * @param bipItemEvalParmVO
     * @return
     */
    PagingVO<BipItemEvalDetailAppRespVO> findItemEvalAppPage(BipItemEvalParmVO bipItemEvalParmVO);

    /**
     * 查询评价
     * @param bipItemEvalParmVO
     * @return
     */
     List<BipItemEvalRespVO> findItemEval(BipItemEvalParmVO bipItemEvalParmVO);

    /**
     *
     * @param bipItemEvalSaveVO
     */
     void saveItemEval(BipItemEvalSaveVO bipItemEvalSaveVO);


    /**
     * 更新评价
     * @param bipItemEvalDetailSaveVOList
     */
    void updateItemEval(List<BipItemEvalDetailSaveVO> bipItemEvalDetailSaveVOList);

    /**
     * 根据id 查询评价
     * @param id
     */
    BipItemEvalRespVO findItemEval(Long id);


    /**
     * 更新评价隐藏状态
     * @param bipItemEvalSimpleSaveVO
     */
    void updateItemEvalIsShow(BipItemEvalSimpleSaveVO bipItemEvalSimpleSaveVO);


     void replayItemEval(BipItemEvalDetailSaveVO bipItemEvalDetailSaveVO);

     void deleteItemEvalByIds(List<Long> ids);

    /**
     * 统计商品评价的数量
     *
     * @param itemId   商品ID，不可为空
     * @param minScore 最低评分
     * @return 数量
     */
    ApiResult<Long> countItemEval(Long itemId, Integer minScore);

    /**
     * 计算商品评价得分
     *
     * @param itemId 商品ID，不可为空
     * @return 评价得分
     */
    ApiResult<BigDecimal> countItemEvalScore(Long itemId);

    /**
     * 根据订单号查询订单
     * @param orderId
     * @return
     */
    BipItemEvalAppRespVO findItemEvalByOrderId(Long orderId);

}
