package com.elitesland.yst.production.sale.api.service.shop;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipMessageQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipMessageVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.app.BipFirstMessage;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipMessageSaveVO;

/**
 * <p>
 * 消息业务接口
 * </p>
 *
 * @author Shadow
 * @since 2021-08-23 15:45:32
 */
public interface BipMessageService {

    /**
     * 检索
     *
     * @param queryParam 分类查询、分页和排序对象
     * @return 分页结果集
     */
    PagingVO<BipMessageVO> search(BipMessageQueryParamVO queryParam);

    /**
     * 创建
     *
     * @param param 对象
     */
    Long createOne(BipMessageSaveVO param);

    /**
     * 更新
     *
     * @param param 对象
     */
    void update(BipMessageSaveVO param);

    /**
     * 删除
     *
     * @param Id 对象
     */
    void deleteOne(Long Id);

    /**
     * 查询用户的第一条消息
     * @return
     */
    BipFirstMessage firstMessage();

    /**
     * 全部已读
     * @return
     */
    ApiResult<String> allRead();

}


