package com.elitesland.yst.production.sale.api.service.shop;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.MktGiftQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.MktGiftRespVO;

import java.util.List;
import java.util.Optional;

/**
 * <p>
 * 赠品服务
 * </p>
 *
 * @author ssy
 * @since 2021/8/23
 */
public interface MktGiftService {
    /**
     * 检索
     *
     * @param queryParam 分类查询、分页和排序对象
     * @return 分页结果集
     */
    PagingVO<MktGiftRespVO> search(MktGiftQueryVO queryParam);

    /**
     * 根据关键字段，返回对应的vo
     *
     * @param code code
     * @return 对象
     */
    Optional<List<MktGiftRespVO>> findByDiscountGiftCode(String code);

    /**
     * 根据关键字段，返回对应的
     *
     * @param id ID
     * @return 对象
     */
    Optional<MktGiftRespVO> findIdOne(Long id);
}
