package com.elitesland.yst.production.sale.api.vo.param.pri;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.web.multipart.MultipartFile;

import java.io.Serializable;

/**
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/6/3 12:29 下午
 */
@Data
@ApiModel(description = "价格导入相关参数")
public class PriSalePriceImportParam implements Serializable {
    private static final long serialVersionUID = 4163032219917816557L;

    @ApiModelProperty(value = "公司ID", required = true)
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty(value = "公司本位币")
    private String currCode;

    @ApiModelProperty(value = "申请单类型", required = true)
    private String docType;

    @ApiModelProperty(value = "客户等级")
    private String custGroup;

    @ApiModelProperty(value = "导入文件", required = true)
    private MultipartFile file;

}
