package com.elitesland.yst.production.sale.api.vo.param.pri;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 请求参数 - 价格查询
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/5/19 2:13 下午
 */
@Data
@ApiModel(description = "价格请求参数")
public class PriSalePriceTypeQueryParam implements Serializable {
    private static final long serialVersionUID = 955965543378950852L;

    @ApiModelProperty(value = "公司ID", required = true)
    @NotNull(message = "公司ID不得为空")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty(value = "货币码", required = true)
    @NotBlank(message = "货币码不得为空")
    private String currCode;

    @ApiModelProperty(value = "价格类型：基础价BASE、客户价CUST、客户等级价GROUP", required = true)
    @NotBlank(message = "价格类型不得为空")
    private String priceType;

    @ApiModelProperty(value = "客户ID，查询客户价必传")
    private Long custId;

    @ApiModelProperty(value = "客户等级，查询客户等级价必传")
    private String custLevel;

    @ApiModelProperty(value = "商品ID", required = true)
    @NotNull(message = "商品ID不得为空")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty(value = "计量单位", required = true)
    @NotBlank(message = "计量单位不得为空")
    @JsonSerialize(using = ToStringSerializer.class)
    private String uom;
}
