package com.elitesland.yst.production.sale.api.vo.param.pro;

import com.elitesland.yst.production.sale.api.vo.resp.com.ComSaleFileComVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

/**
 * 请求参数 - 销售合同新增
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/6/9 8:16 下午
 */
@Data
@ApiModel(description = "销售合同新增请求参数")
public class SalContractSaveParam implements Serializable {

    private static final long serialVersionUID = 313338666580919795L;

    @ApiModelProperty(value = "主键ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty(value = "公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty(value = "合同编号")
    private String contractNo;

    @ApiModelProperty("外部合同号")
    private String contractNo2;

    @ApiModelProperty("合同版本")
    private Integer contractVersion;

    @ApiModelProperty(value = "合同名称", required = true)
    @NotBlank(message = "合同名称不得为空")
    private String contractName;

    @ApiModelProperty("项目id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long projId;

    @ApiModelProperty("项目名称")
    private String projName;

    @ApiModelProperty("项目编码")
    private String projCode;

    @ApiModelProperty("CRM项目名称")
    private String projCode2;

    @ApiModelProperty("合同类型")
    private String contractType;

    @ApiModelProperty("合同状态")
    private String contractStatus;

    @ApiModelProperty("合同质保期 数字N年")
    private String guaranteePeriod;

    @ApiModelProperty("城市")
    private String contractCity;

    @ApiModelProperty("费用承担方")
    private String feeCarrier;

    @ApiModelProperty(value = "交货时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate deliverDate;

    @ApiModelProperty("产品安装")
    private String installFlag;

    @ApiModelProperty("币种")
    private String currCode;

    @ApiModelProperty(value = "签约日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate signDate;

    @ApiModelProperty(value = "开始日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate beginDate;

    @ApiModelProperty(value = "结束日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate endDate;

    @ApiModelProperty("合同总金额")
    private BigDecimal totalAmt;

    @ApiModelProperty("交付详细地址")
    private String deliverAddress;

    @ApiModelProperty("审批意见")
    private String apprComment;

    @ApiModelProperty("是否需要项目验收")
    private Boolean projConfirmFlag;

    @ApiModelProperty("合同质保金")
    private BigDecimal guaranteeAmt;

    @ApiModelProperty("配送方式")
    private String deliverMethod;

    @ApiModelProperty("客户ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long custId;

    @ApiModelProperty(value = "客户编号", required = true)
    @NotBlank(message = "客户编号不得为空")
    private String custCode;

    @ApiModelProperty(value = "客户名称", required = true)
    @NotBlank(message = "客户名称不得为空")
    private String custName;

    @ApiModelProperty("客户联系人")
    private String custPic;

    @ApiModelProperty("客户联系人电话")
    private String custPicTel;

    @ApiModelProperty("客户地址")
    private String custAddress;

    @ApiModelProperty(value = "签约公司", required = true)
    @NotBlank(message = "签约公司不得为空")
    private String bSignOu;
    private String bSignOuCode;

    @ApiModelProperty(value = "签约部门", required = true)
    @NotBlank(message = "签约部门不得为空")
    private String bSignDept;

    @ApiModelProperty(value = "区域", required = true)
    @NotBlank(message = "区域")
    private String bRegion;

    @ApiModelProperty("销售员")
    private String bSalesman;

    @ApiModelProperty("销售员电话")
    private String bSalesmanTel;

    @ApiModelProperty("签约公司地址")
    private String bAddress;

    @ApiModelProperty("丙方编码")
    private String cCode;

    @ApiModelProperty("丙方名称")
    private String cName;

    @ApiModelProperty("丙方联系人")
    private String cContact;

    @ApiModelProperty("丙方联系人电话")
    private String cContactTel;

    @ApiModelProperty("丙方地址")
    private String cAddress;

    @ApiModelProperty("来源单据类型")
    private String rootDocType;

    @ApiModelProperty("来源单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long rootDocId;

    @ApiModelProperty("来源单据编号")
    private String rootDocNo;

    @ApiModelProperty("来源单据类别 [UDC]COM:DOC_CLS")
    private String rootDocCls;

    @ApiModelProperty("合同明细 产品基本信息列表")
    private List<SalContractDSaveParam> itemDetails;

    @ApiModelProperty("收款计划")
    private List<SalContractRecvSaveParam> contractRecvs;

    @ApiModelProperty("附件")
    private List<ComSaleFileComVO> attachFiles;

    @ApiModelProperty("签约背景")
    private String signBackground;

    @ApiModelProperty("质保金尾款")
    private BigDecimal endAmt;

    /**
     * 是否启用经营目录
     */
    @ApiModelProperty(value = "是否启用经营目录")
    private Integer catalogueFlag;
}
