package com.elitesland.yst.production.sale.api.vo.param.sal;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 业绩提成规则(SalCommissionRule)实体类
 *
 * @author makejava
 * @since 2021-11-22 17:55:32
 */
@Data
@ApiModel(value = "sal_commission_rule", description = "业绩提成规则")
public class SalCommissionRuleParam extends AbstractOrderQueryParam {
    private static final long serialVersionUID = -88148693848255548L;
    /**
     * 记录唯一ID
     */
    @ApiModelProperty("记录唯一ID")
    private List<Long> ids;
    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    private Long ouId;
    /**
     * 公司编号
     */
    @ApiModelProperty("公司编号")
    private String ouCode;
    /**
     * 公司名称
     */
    @ApiModelProperty("公司名称")
    private String ouName;
    /**
     * 商品品类编号
     */
    @ApiModelProperty("商品品类编号")
    private String itemCateCode;
    /**
     * 商品ID
     */
    @ApiModelProperty("商品ID")
    private Long itemId;
    /**
     * 商品编号
     */
    @ApiModelProperty("商品编号")
    private String itemCode;
    /**
     * 商品名称
     */
    @ApiModelProperty("商品名称")
    private String itemName;
    /**
     * 提成规则 UDC:SAL/COMMISSION_RULE
     */
    @ApiModelProperty("提成规则 UDC:SAL/COMMISSION_RULE")
    private String commissionRule;
    /**
     * 提成百分比
     */
    @ApiModelProperty("提成百分比")
    private BigDecimal percentage;
    /**
     * 计件提成每件提成（元）
     */
    @ApiModelProperty("计件提成每件提成（元）")
    private BigDecimal pieceWage;

}
