package com.elitesland.yst.production.sale.api.vo.param.sal;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @auther JinXK
 * @date 2021/6/12 16:54
 */
@Data
@ApiModel(description = "收款单分页查询入参")
public class SalReceiptPageParam extends AbstractOrderQueryParam implements Serializable {
    private static final long serialVersionUID = 517591449221349242L;

    @ApiModelProperty(value = "主键ID")
    private Long id;

    @ApiModelProperty(value = "单据编号")
    private String docNo;

    @ApiModelProperty(value = "销售单号")
    private String soDocNo;

    @ApiModelProperty(value = "公司ID")
    private Long ouId;

    @ApiModelProperty(value = "客户名称")
    private String custName;

    @ApiModelProperty(value = "客户编号")
    private String custCode;

    @ApiModelProperty(value = "合同编号")
    private String contractCode;

    @ApiModelProperty(value = "合同名称")
    private String contractName;

    @ApiModelProperty(value = "单据状态 [UDC]SAL:RECEIPT_STATUS")
    private String docStatus;

    @ApiModelProperty(value = "申请日期-start")
    private LocalDateTime applyDateStart;

    @ApiModelProperty(value = "申请日期-end")
    private LocalDateTime applyDateEnd;

    @ApiModelProperty(value = "申请人员工ID")
    private Long applyEmpId;

    @ApiModelProperty(value = "申请人姓名")
    private String applyName;

    @ApiModelProperty(value = "收款类型 [UDC]SAL:RECEIPT_TYPE")
    private String receiptType;

    @ApiModelProperty(value = "收款方式 [UDC]COM:PAY_METHOD")
    private String payMethod;

    @ApiModelProperty(value = "是否公对公收款")
    private String b2bFlag;

    @ApiModelProperty(value = "销售区域 [UDC]SAL:SAL_REGION")
    private String saleRegion;

    @ApiModelProperty(value = "相关单据编号 原始单号")
    private String relateDocNo;

    @ApiModelProperty(value = "核销状态 [UDC]SAL:RECEIPT_WRITEOFF")
    private String docStatus2;

    @ApiModelProperty(value = "单据类型 收款单(RE) 退款单(RD)")
    private String docType;

}
