package com.elitesland.yst.production.sale.api.vo.param.sal;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @auther JinXK
 * @date 2021/7/7 14:32
 */
@Data
@ApiModel(description = "对账单导出分页查询入参")
public class SalSoaExportPageParam extends AbstractOrderQueryParam implements Serializable {

    private static final long serialVersionUID = -3483942412059081924L;

    @ApiModelProperty(value = "主键ID")
    private List<Long> ids;

    @ApiModelProperty(value = "对账单号")
    private String docNo;

    @ApiModelProperty(value = "对账日期-start")
    private LocalDateTime soaDateStart;

    @ApiModelProperty(value = "对账日期-end")
    private LocalDateTime soaDateEnd;

    @ApiModelProperty(value = "公司ID")
    private Long ouId;

    @ApiModelProperty(value = "公司编码")
    private String ouCode;

    @ApiModelProperty(value = "客户名称")
    private String custName;

    @ApiModelProperty(value = "申请人姓名")
    private String applyName;

    @ApiModelProperty(value = "对账单状态")
    private String soaStatus;

    @ApiModelProperty(value = "对账单收款状态[UDC]SAL:SOA_RECEIPT_STATUS")
    private String soaReceiptStatus;

    @ApiModelProperty(value = "对账单开票状态[UDC]SAL:SOA_INV_STATUS")
    private String soaInvStatus;

    @ApiModelProperty(value = "发货单编号")
    private String doDocNo;

    @ApiModelProperty(value = "销售订单编号")
    private String soNo;

    @ApiModelProperty(value = "税率")
    private BigDecimal taxRate;

}
