package com.elitesland.yst.production.sale.api.vo.param.shop;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 订单表(BipRetationChart)实体类
 *
 * @author Shadow
 * @since 2021-08-11 15:08:51
 */
@Data
@ApiModel(value = "BipRotationChartQueryParamVO", description = "订单表")
public class BipRotationChartQueryParamVO extends AbstractOrderQueryParam {
    private static final long serialVersionUID = -46926179777142345L;
    /**
     * 记录唯一ID
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;

    @ApiModelProperty("公司id")
    private Long ouId;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("状态")
    private String status;
    /**
     * 满减折扣Id
     */
    @ApiModelProperty("满减折扣Id")
    private Long offsetId;
    /**
     * 满减折扣编码
     */
    @ApiModelProperty("满减折扣编码")
    private String offsetCode;
    /**
     * 满减去折扣名称
     */
    @ApiModelProperty("满减去折扣名称")
    private String offsetName;
    /**
     * 满赠折扣Id
     */
    @ApiModelProperty("满赠折扣Id")
    private Long giftId;
    /**
     * 满赠折扣编码
     */
    @ApiModelProperty("满赠折扣编码")
    private String giftCode;
    /**
     * 满赠折扣名称
     */
    @ApiModelProperty("满赠折扣名称")
    private String giftCname;
    /**
     * 描述
     */
    @ApiModelProperty("描述")
    private String retationDesc;
    /**
     * 优先级
     */
    @ApiModelProperty("优先级")
    private String priority;
    /**
     * 图片id
     */
    @ApiModelProperty("图片id")
    private Long picId;
    /**
     * 轮播图停留时间，单位s
     */
    @ApiModelProperty("轮播图停留时间，单位s")
    private Long lastTime;
    /**
     * 开始时间
     */
    @ApiModelProperty("开始时间")
    private LocalDateTime stime;
    /**
     * 结束时间
     */
    @ApiModelProperty("结束时间")
    private LocalDateTime etime;

}
