package com.elitesland.yst.production.sale.api.vo.param.taskinfo;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;


/**
 * @author : WWW
 * @date : 2023-6-1
 * @desc : 销售业绩统计-经销商
 */

@Data
@ApiModel(description = "销售业绩统计-经销商")
public class SaleStatisticsDealerQueryVO extends AbstractOrderQueryParam {

    private static final long serialVersionUID = 5634651735073460154L;

    @ApiModelProperty("主键ID")
    private Long id;
    @ApiModelProperty("主键ID集合")
    private List<Long> ids;
    /**
     * 统计时间
     */
    @ApiModelProperty("统计时间")
    private LocalDateTime docTime;
    @ApiModelProperty("统计时间起始")
    private LocalDateTime docTimeStart;
    @ApiModelProperty("统计时间截至")
    private LocalDateTime docTimeEnd;
    @ApiModelProperty("统计月份(yyyy-MM)")
    private String docMonth;

    @ApiModelProperty("统计时间起始(yyyyMM)")
    @JsonIgnore
    private Integer docTimeItStart;
    @ApiModelProperty("统计时间截至(yyyyMM)")
    @JsonIgnore
    private Integer docTimeItEnd;

    @ApiModelProperty("汇总出货量 左区间")
    private BigDecimal shipTotalQtyFrom;
    @ApiModelProperty("汇总出货量 右区间")
    private BigDecimal shipTotalQtyTo;
    @ApiModelProperty("汇总订货量 左区间")
    private BigDecimal orderTotalQtyFrom;
    @ApiModelProperty("汇总订货量 右区间")
    private BigDecimal orderTotalQtyTo;

    /**
     * 经销商编码
     */
    @ApiModelProperty("经销商编码")
    private String dealerCode;
    @ApiModelProperty("经销商编码集合")
    private List<String> dealerCodeList;
    @ApiModelProperty("经销商编码模糊查询")
    private String dealerCodeKeyword;
    /**
     * 经销商名称
     */
    @ApiModelProperty("经销商名称")
    private String dealerName;

    @ApiModelProperty("经销商编码/名称模糊查询")
    private String dealerKeyword;

    /**
     * 经销商客户号
     */
    @ApiModelProperty("经销商客户号,模糊查询")
    private String dealerSerialNo;
    @ApiModelProperty("经销商客户号，精确查询")
    private String dealerSerialNo1;

    /**
     * 区域
     */
    @ApiModelProperty("区域")
    private String region;
    @ApiModelProperty("区域集合")
    private List<String> regionList;
    @ApiModelProperty("区域为空时")
    private Integer regionFlag;
    @ApiModelProperty("区域是否为空(下拉选项，是/否，判断区域字段是否为null)")
    private String regionEmptyFlag;
    /**
     * 类型
     */
    @ApiModelProperty("类型")
    private String type;
    @ApiModelProperty("类型集合")
    private List<String> typeList;
    /**
     * 业务员关系路径
     */
    @ApiModelProperty("业务员关系路径")
    private String salesmanPath;
    @ApiModelProperty("业务员关系路径为空时")
    private Integer salesmanPathFlag;
    @ApiModelProperty("业务员关系路径是否为空(下拉选项，是/否，判断业务员关系路径字段是否为null)")
    private String salesmanPathEmptyFlag;
    /**
     * 车型
     */
    @ApiModelProperty("车型")
    private String vehicleType;
    @ApiModelProperty("车型集合")
    private List<String> vehicleTypeList;
    /**
     * 出货量
     */
    @ApiModelProperty("出货量")
    private BigDecimal shipQty;
    @ApiModelProperty("汇总出货量")
    private BigDecimal shipTotalQty;
    /**
     * 订货量
     */
    @ApiModelProperty("订货量")
    private BigDecimal orderQty;
    @ApiModelProperty("汇总订货量")
    private BigDecimal orderTotalQty;

    /**
     * 客户类型
     */
    @ApiModelProperty("客户类型")
    private String custType;
    @ApiModelProperty("客户类型集合")
    private List<String> custTypes;
    /**
     * 整车类型
     */
    @ApiModelProperty("整车类型")
    private String itemType3;
    @ApiModelProperty("整车类型集合")
    private List<String> itemType3List;

    @ApiModelProperty(value = "所属业务员编码")
    private String agentEmp;
    @ApiModelProperty(value = "所属业务员编码集合")
    private List<String> agentEmpList;
    @ApiModelProperty("层级：  0——默认是客户所属的业务员  1、2、...——依次往上查询上级赋值")
    private String level;

    @ApiModelProperty("用户id")
    private Long userId;

    @ApiModelProperty("查看自己:true 查看自己,false 查看团队")
    private Boolean seeSelf;

    @ApiModelProperty("更新区域失败原因")
    private String updateRegionFailureReason;

    @ApiModelProperty("更新业务员失败原因")
    private String updateSalesmanFailureReason;

    @ApiModelProperty("是否刷新历史数据，勿用仅测试")
    private Boolean refreshHistory;
}

