package com.elitesland.yst.production.sale.api.vo.resp.crm;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
@ApiModel(description = "客户登录信息返回")
public class CustLoginLogRespVO {

    @ApiModelProperty(value = "账号ID")
    private Long userId;

    @ApiModelProperty(value = "余额")
    private BigDecimal balance;

    @ApiModelProperty(value = "客户类型")
    private String custType;

    @ApiModelProperty(value = "联系人")
    private String contactName;

    @ApiModelProperty(value = "手机号")
    private String mobile;

    @ApiModelProperty(value = "登录账号")
    private String userName;

    @ApiModelProperty(value = "上次登录时间")
    private LocalDateTime lastLoginTime;

    @ApiModelProperty(value = "上次登录IP")
    private String lastLoginIp;

    @ApiModelProperty(value = "本次登录时间")
    private LocalDateTime thisLoginTime;

    @ApiModelProperty(value = "本次登录IP")
    private String thisLoginIp;

    @ApiModelProperty(value = "修改时间")
    private LocalDateTime modifyTime;

    @ApiModelProperty(value = "注册时间")
    private LocalDateTime registTime;






}
