package com.elitesland.yst.production.sale.api.vo.resp.pri;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 价格信息返回参数
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/5/19 2:23 下午
 */
@ApiModel(description = "价格信息返回参数")
@Data
public class PriSalePricePageRespVO implements Serializable {
    private static final long serialVersionUID = 6515297085348885987L;

    @ApiModelProperty(value = "Id")
    private Long id;

    @ApiModelProperty(value = "公司Id")
    private Long ouId;
    @ApiModelProperty(value = "公司名称")
    private String ouName;

    @ApiModelProperty(value = "客户ID")
    private Long custId;
    @ApiModelProperty(value = "客户编码")
    private String custCode;
    @ApiModelProperty(value = "客户名称")
    private String custName;

    @ApiModelProperty(value = "客户等级")
    @SysCode(sys = "yst-sale", mod = "CUST_GROUP")
    private String custGroup;
    private String custGroupName;

    @ApiModelProperty(value = "销售区域")
    @SysCode(sys = "yst-supp", mod = "OU_REGION")
    private String saleRegion;
    private String saleRegionName;

    @ApiModelProperty(value = "商品ID")
    private Long itemId;
    @ApiModelProperty(value = "商品编号")
    private String itemCode;
    @ApiModelProperty(value = "商品名称")
    private String itemName;
    @ApiModelProperty(value = "商品条码")
    private String barcode;
    @ApiModelProperty(value = "商品规格/型号")
    private String itemSpec;
    @ApiModelProperty(value = "商品品类编码")
    private String itemCateCode;
    @ApiModelProperty(value = "商品品类全路径")
    private String itemCatePath;

    @ApiModelProperty(value = "商品单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom;
    private String uomName;

    @ApiModelProperty(value = "市场价")
    private BigDecimal marketPrice;

    @ApiModelProperty(value = "指导价")
    private BigDecimal guidePrice;

    @ApiModelProperty(value = "销售底价")
    private BigDecimal floorPrice;

    @ApiModelProperty(value = "含税价格")
    private BigDecimal price;
    private BigDecimal netPrice;

    @ApiModelProperty(value = "税率编号")
    private String taxRateNo;
    @ApiModelProperty(value = "税率编号描述")
    private String taxRateDesc;
    @ApiModelProperty(value = "税率")
    private BigDecimal taxRate;

    @ApiModelProperty(value = "货币码")
    private String currCode;
    @ApiModelProperty(value = "币种名称")
    private String currName;

    @ApiModelProperty(value = "价格类型 [UDC]PRI:SALE_PRICE_TYPE")
    @SysCode(sys = "PRI", mod = "SALE_PRICE_TYPE")
    private String priceType;
    private String priceTypeName;

    @ApiModelProperty(value = "价格状态")
    private String priceStatus;
    private String priceStatusName;

    @ApiModelProperty(value = "生效时间")
    private LocalDateTime validFrom;
    @ApiModelProperty(value = "失效时间")
    private LocalDateTime validTo;

    @ApiModelProperty(value = "备注")
    private String remark;

    // 活动价格新增
    @ApiModelProperty(value = "活动价生效日期")
    private LocalDateTime promDateF;

    @ApiModelProperty(value = "活动价失效日期")
    private LocalDateTime promDateT;

    @ApiModelProperty("活动含税价格")
    private BigDecimal promotionPrice;

    @ApiModelProperty("活动不含税价格")
    private BigDecimal promotionNetPrice;

    @ApiModelProperty(value = "创建人ID")
    private Long createUserId;
    @ApiModelProperty(value = "创建人")
    private String creator;
    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "更新人")
    private String updater;
    @ApiModelProperty(value = "更新人ID")
    private Long modifyUserId;
    @ApiModelProperty(value = "更新时间")
    private LocalDateTime modifyTime;

}
