package com.elitesland.yst.production.sale.api.vo.resp.pri;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/6/5 3:15 下午
 */
@Data
public class PriSalePriceRespInVO implements Serializable {

    private static final long serialVersionUID = -1479782657315536699L;

    @ApiModelProperty(value = "商品ID")
    private Long itemId;

    @ApiModelProperty(value = "商品编码")
    private String itemCode;

    @ApiModelProperty(value = "计量单位")
    private String uom;

    @ApiModelProperty(value = "基础价格")
    private BigDecimal basePrice;

    @ApiModelProperty(value = "销售价格")
    private BigDecimal salePrice;

    @ApiModelProperty(value = "销售底价")
    private BigDecimal floorPrice;

    @ApiModelProperty(value = "税率")
    private BigDecimal taxRate;

    @ApiModelProperty(value = "针对明细的错误信息，未获取到销售价或计量单位转换率")
    private String errorMsg;

}
