package com.elitesland.yst.production.sale.api.vo.resp.pri;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/6/1 7:34 下午
 */
@ApiModel(description = "价格信息返回参数")
@Data
public class PriSalePriceTypeRespVO implements Serializable {
    private static final long serialVersionUID = 6555445286722645412L;

    @ApiModelProperty(value = "公司ID")
    private Long ouId;

    @ApiModelProperty(value = "客户ID")
    private Long custId;

    @ApiModelProperty(value = "客户等级")
    private String custLevel;

    @ApiModelProperty(value = "币种")
    private String currCode;

    @ApiModelProperty(value = "商品ID")
    private Long itemId;

    @ApiModelProperty(value = "单位")
    private String uom;

    @ApiModelProperty(value = "商品税率")
    private BigDecimal taxRate;

    @ApiModelProperty(value = "含税价格")
    private BigDecimal price;

    @ApiModelProperty(value = "不含税价格")
    private BigDecimal netPrice;

}
