package com.elitesland.yst.production.sale.api.vo.resp.pro;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;

/**
 * 返回参数 - 项目信息
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/6/7 8:11 下午
 */
@ApiModel(description = "项目返回参数")
@Data
public class SalProjPageRespVO implements Serializable {
    private static final long serialVersionUID = 251496831782837316L;

    @ApiModelProperty("主键ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty(value = "公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty(value = "组织ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;
    private String buName;

    @ApiModelProperty(value = "公司名称")
    private String ouName;

    @ApiModelProperty(value = "区域 [UDC]ORG:OU_REGION")
    @SysCode(sys = "yst-supp", mod = "OU_REGION")
    private String region;
    private String regionName;

    @ApiModelProperty("项目编号")
    private String projNo;

    @ApiModelProperty("项目名称")
    private String projName;

    @ApiModelProperty("项目类型")
    @SysCode(sys = "yst-sale", mod = "PROJ_TYPE")
    private String projType;
    private String projTypeName;

    @ApiModelProperty("项目地址")
    private String projAddress;

    @ApiModelProperty("客户ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long custId;

    @ApiModelProperty("客户编号")
    private String custCode;

    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("客户地址")
    private String custAddress;

    @ApiModelProperty("客户负责人")
    private String custPic;

    @ApiModelProperty("客户负责人电话")
    private String custPicTel;

    @ApiModelProperty(value = "报装户数")
    private Long installNum;

    @ApiModelProperty(value = "报装日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate installDate;

    @ApiModelProperty(value = "项目安装时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate projInstallTime;

    @ApiModelProperty(value = "项目开盘时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate projOpenTime;

    @ApiModelProperty("项目付款方式")
    @SysCode(sys = "yst-sale", mod = "PROJ_PAYMENT_TYPE")
    private String projPayMethod;
    private String projPayMethodName;

    @ApiModelProperty("客户类型(正式/潜在)")
    @SysCode(sys = "yst-sale",mod = "QT_TYPE")
    private String custType2;
    private String custType2Name;

}
