package com.elitesland.yst.production.sale.api.vo.resp.sal;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.yst.production.sale.api.vo.resp.com.ComSaleFileComVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @auther JinXK
 * @date 2021/6/12 15:24
 */
@Data
@ApiModel(description = "销售收款单参数(通用)")
public class SalReceiptRespVO implements Serializable {
    private static final long serialVersionUID = -7038091419124119641L;

    @ApiModelProperty(value = "主键ID")
    private Long id;

    @ApiModelProperty(value = "公司ID")
    private Long ouId;

    @ApiModelProperty(value = "公司编号")
    private String ouCode;

    @ApiModelProperty(value = "公司名称")
    private String ouName;

    @ApiModelProperty(value = "销售组织id")
    private Long buId;

    @ApiModelProperty(value = "销售组织名称")
    private String buName;

    @ApiModelProperty(value = "单据编号")
    private String docNo;

    @ApiModelProperty(value = "单据类型 收款单(RE) 退款单(RD)")
    private String docType;

    @ApiModelProperty(value = "单据状态 [UDC]SAL:RECEIPT_STATUS")
    @SysCode(sys = "yst-sale", mod = "RECEIPT_STATUS")
    private String docStatus;
    private String docStatusName;

    @ApiModelProperty(value = "申请人员工ID")
    private Long applyEmpId;

    @ApiModelProperty(value = "申请人姓名")
    private String applyName;

    @ApiModelProperty(value = "申请日期")
    private LocalDateTime applyDate;

//    @ApiModelProperty(value = "申请描述")
//    private String applyDesc;

//    @ApiModelProperty(value = "审批状态 [UDC]COM:APPR_STATUS")
//    private String apprStatus;

//    @ApiModelProperty(value = "审批时间")
//    private LocalDateTime apprTime;
//
    @ApiModelProperty(value = "审批人ID")
    private Long apprUserId;

    @ApiModelProperty(value = "审批人姓名")
    private String apprUserName;

    @ApiModelProperty(value = "审批意见")
    private String apprComment;

    @ApiModelProperty(value = "收款方式 [UDC]COM:PAY_METHOD")
    private String payMethod;
    private String payMethodName;

//    @ApiModelProperty(value = "店铺ID")
//    private Long storeId;
//
//    @ApiModelProperty(value = "店铺编号")
//    private String storeCode;
//
//    @ApiModelProperty(value = "店铺名称")
//    private String storeName;

    @ApiModelProperty(value = "预计到款日期")
    private LocalDateTime planReceiptDate;

    @ApiModelProperty(value = "是否公对公收款")
    private String b2bFlag;

    @ApiModelProperty(value = "是否红冲")
    private String offFlag;
//
//    @ApiModelProperty(value = "已红冲金额")
//    private BigDecimal offedAmt;
//
//    @ApiModelProperty(value = "红冲中金额")
//    private BigDecimal offingAmt;

    @ApiModelProperty(value = "相关单据ID")
    private Long relateDocId;

    @ApiModelProperty(value = "相关单据编号 原始单号")
    private String relateDocNo;

    @ApiModelProperty(value = "原单类型")
    @SysCode(sys = "yst-sale", mod = "RECEIPT_TYPE")
    private String relateReceiptType;
    private String relateReceiptTypeName;

    @ApiModelProperty(value = "原单押金余额")
    private BigDecimal relateOpenAmt;

    @ApiModelProperty(value = "收款类型 [UDC]SAL:RECEIPT_TYPE")
    private String receiptType;
    private String receiptTypeName;

    @ApiModelProperty(value = "收款金额")
    private BigDecimal amt;

    @ApiModelProperty(value = "税额")
    private BigDecimal tax;

    @ApiModelProperty(value = "出票人全称")
    private String ckName;

    @ApiModelProperty(value = "出票人账号")
    private String ckAccNo;

    @ApiModelProperty(value = "出票人开户银行")
    private String ckBank;

    @ApiModelProperty(value = "出票日期")
    private LocalDateTime ckDate;

    @ApiModelProperty(value = "汇票到期日")
    private LocalDateTime ckDuedate;

    @ApiModelProperty(value = "票号")
    private String ckNo;

    @ApiModelProperty(value = "票据金额")
    private BigDecimal ckAmt;

    @ApiModelProperty(value = "票据状态")
    private String ckStatus;

    @ApiModelProperty(value = "承兑人及信息")
    private String ckAccepter;

    @ApiModelProperty(value = "能否转让")
    private String ckAllowtrFlag;

//    @ApiModelProperty(value = "下单渠道 [UDC]SAL:SO_SOURCE")
//    @SysCode(sys = "yst-sale", mod = "SO_SOURCE")
//    private String soSource;
//    private String soSourceName;

    @ApiModelProperty(value = "合同编号")
    private String contractCode;

    @ApiModelProperty(value = "出票银行")
    private String ckBank1;

    @ApiModelProperty(value = "销售区域 [UDC]ORG:OU_REGION")
    @SysCode(sys = "yst-supp", mod = "OU_REGION")
    private String saleRegion;
    private String saleRegionName;

    @ApiModelProperty(value = "合同名称")
    private String contractName;

    @ApiModelProperty(value = "合同ID")
    private Long contractId;

    @ApiModelProperty(value = "客户名称")
    private String custName;

    @ApiModelProperty(value = "客户编号")
    private String custCode;

    @ApiModelProperty(value = "客户ID")
    private Long custId;

    @ApiModelProperty(value = "已核销金额")
    private BigDecimal writeoffAmt;

    @ApiModelProperty(value = "已转货款金额")
    private BigDecimal transferAmt;

    @ApiModelProperty(value = "转货款中金额")
    private BigDecimal transferingAmt;

    @ApiModelProperty(value = "已退款金额")
    private BigDecimal returnAmt;

    @ApiModelProperty(value = "退款中金额")
    private BigDecimal returningAmt;

    @ApiModelProperty(value = "押金余额")
    private BigDecimal openAmt;

    @ApiModelProperty(value = "核销状态 [UDC]SAL:RECEIPT_WRITEOFF")
    @SysCode(sys = "yst-sale", mod = "RECEIPT_WRITEOFF")
    private String docStatus2;
    private String docStatus2Name;

    @ApiModelProperty(value = "销售单号")
    private String soNo;

    @ApiModelProperty(value = "对账单或销售单--对账单(SOA) 销售单(SO)")
    private String soaOrSo;

    @ApiModelProperty(value = "银行ID")
    private Long bankId;

    @ApiModelProperty(value = "开户行代码")
    private String bankCode;

    @ApiModelProperty(value = "开户行名称")
    private String bankName;

    @ApiModelProperty(value = "开户行账号")
    private String bankAcc;

    @ApiModelProperty(value = "开户姓名")
    private String holderName;

    @ApiModelProperty(value = "退款原因")
    private String reason;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "客户联系人")
    private String custContactName;

    @ApiModelProperty(value = "客户联系人电话")
    private String custContactTel;
    @ApiModelProperty(value = "币种编码")
    private String currCode;

    @ApiModelProperty(value = "币种名称")
    private String currName;

    @ApiModelProperty(value = "创建人Id")
    private Long createUserId;

    @ApiModelProperty(value = "创建人姓名")
    private String creator;

    @ApiModelProperty(value = "收款账号")
    private String ouBankAcc;

    @ApiModelProperty(value = "收款户名")
    private String ouHolderName;

    @ApiModelProperty(value = "收款流水")
    private String receiptSerial;

    @ApiModelProperty(value = "附件")
    private List<ComSaleFileComVO> attachFiles;

    @ApiModelProperty(value = "销售收款明细列表")
    private List<SalReceiptdRespVO> salReceiptdRespVOS;

}
