package com.elitesland.yst.production.sale.api.vo.resp.sal;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.yst.production.sale.api.vo.resp.com.ComSaleFileComVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @auther JinXK
 * @date 2021/7/7 9:52
 */
@Data
@ApiModel(description = "客户对账单参数(通用)")
public class SalSoaRespVO implements Serializable {
    private static final long serialVersionUID = 7717369491277079045L;

    @ApiModelProperty(value = "主键ID")
    private Long id;

    @ApiModelProperty(value = "对账单号")
    private String docNo;

    @ApiModelProperty(value = "客户ID")
    private Long custId;

    @ApiModelProperty(value = "客户编码")
    private String custCode;

    @ApiModelProperty(value = "客户名称")
    private String custName;

    @ApiModelProperty(value = "公司ID")
    private Long ouId;

    @ApiModelProperty(value = "销售组织id")
    private Long buId;

    @ApiModelProperty(value = "销售组织名称")
    private String buName;


    @ApiModelProperty(value = "公司编码")
    private String ouCode;

    @ApiModelProperty(value = "公司名称")
    private String ouName;

    @ApiModelProperty(value = "对账日期")
    private LocalDateTime soaDate;

    @ApiModelProperty(value = "币种")
    private String currCode;

    @ApiModelProperty(value = "币种名称(仅作为翻译字段)")
    private String currName;

    @ApiModelProperty(value = "对账单状态 [UDC]SAL:SOA_STATUS")
    @SysCode(sys = "yst-sale", mod = "SOA_STATUS")
    private String soaStatus;
    private String soaStatusName;

    @ApiModelProperty(value = "申请人员工ID")
    private Long applyEmpId;

//    @ApiModelProperty(value = "含税发运总金额")
//    private BigDecimal shippedAmt;

//    @ApiModelProperty(value = "未税发运总金额")
//    private BigDecimal shippedNetAmt;

//    @ApiModelProperty(value = "发运税额")
//    private BigDecimal shippedTaxAmt;

//    @ApiModelProperty(value = "已签收金额")
//    private BigDecimal confirmAmt;

//    @ApiModelProperty(value = "未税签收总金额")
//    private BigDecimal confirmNetAmt;

//    @ApiModelProperty(value = "签收税额")
//    private BigDecimal confirmTaxAmt;

    @ApiModelProperty(value = "对账金额")
    private BigDecimal soaAmt;

    @ApiModelProperty(value = "未税对账总金额")
    private BigDecimal soaNetAmt;

    @ApiModelProperty(value = "对账税额")
    private BigDecimal soaTaxAmt;

    @ApiModelProperty(value = "申请人姓名")
    private String applyName;

    @ApiModelProperty(value = "提交日期")
    private LocalDateTime applyDate;

//    @ApiModelProperty(value = "申请描述")
//    private String applyDesc;

    @ApiModelProperty(value = "收款单ID")
    private Long receiptId;

    @ApiModelProperty(value = "收款单号")
    private String receiptNo;

    @ApiModelProperty(value = "开票申请单ID")
    private Long invApplyId;

    @ApiModelProperty(value = "开票申请单号")
    private String invApplyNo;

    @ApiModelProperty(value = "对账单开票状态[UDC]SAL:SOA_INV_STATUS")
    @SysCode(sys = "yst-sale", mod = "SOA_INV_STATUS")
    private String soaInvStatus;
    private String soaInvStatusName;

    @ApiModelProperty(value = "待开票金额")
    private BigDecimal invApplyAmt;

    @ApiModelProperty(value = "开票中金额")
    private BigDecimal invApplyingAmt;

    @ApiModelProperty(value = "已开票金额")
    private BigDecimal invApplyedAmt;

    @ApiModelProperty(value = "对账单收款状态[UDC]SAL:SOA_RECEIPT_STATUS")
    @SysCode(sys = "yst-sale", mod = "SOA_RECEIPT_STATUS")
    private String soaReceiptStatus;
    private String soaReceiptStatusName;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "客户联系人")
    private String custPic;

    @ApiModelProperty(value = "客户联系人电话")
    private String custPicTel;

    @ApiModelProperty(value = "申请人电话")
    private String applyEmpTel;

    @ApiModelProperty(value = "附件")
    private List<ComSaleFileComVO> attachFiles;

    @ApiModelProperty(value = "对账单明细")
    private List<SalSoaDRespVO> salSoaDRespVOList;
}
