package com.elitesland.yst.production.sale.api.vo.resp.salesman;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author Danny.Wang
 * @title SalesmanInfoAppDetailRespVO
 * @Date2023/6/9 13:52
 */
@Data
@ApiModel("业务员app个人资料查询返回参数")
public class SalesmanInfoAppDetailRespVO implements Serializable {

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("头像文件编码")
    private String fileCode;

    @ApiModelProperty("业务员编号")
    private String salesmanNo;

    @ApiModelProperty("业务员类型")
    private String salesmanType;

    @ApiModelProperty("业务员类型名称")
    private String salesmanTypeName;

    @ApiModelProperty("启用状态")
    private Integer enableStatus;

    @ApiModelProperty("启用状态名称")
    private String enableStatusName;

    @ApiModelProperty("手机号")
    private String phone;

    @ApiModelProperty("用户账号")
    private String username;

    @ApiModelProperty("用户姓名")
    private String fullName;

    @ApiModelProperty("组织信息")
    private List<EmployeeOrg> orgList;

    @Data
    public static class EmployeeOrg implements Serializable {
        private static final long serialVersionUID = -7057452386964797575L;

        @ApiModelProperty("组织ID")
        private Long orgId;

        @ApiModelProperty("组织名称")
        private String orgName;

    }

}
