package com.elitesland.yst.production.sale.api.vo.resp.shop;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/06/17:10
 * @Description:
 */
@Data
public class BipCartItemRespVO implements Serializable {
    private static final long serialVersionUID = 5733974264497921336L;

    @ApiModelProperty(value = "购物车ID")
    private Long id;

    @ApiModelProperty("是否首单商品 true是  false不是")
    private Boolean firstItemFlag;

//    @ApiModelProperty(value = "购物车父id")
//    private Long pid;


    @ApiModelProperty(value = "购物车用户id")
    private Long userId;

    @ApiModelProperty(value = "购物车用户姓名")
    private String userName;


    @ApiModelProperty(value = "购买数量")
    private Long itemNum;


    //s商品详细信息
    @ApiModelProperty(value = "上架编码")
    private String shelfCode;

    @ApiModelProperty(value = "一级商品分类ID")
    private Long categoryId1;

    @ApiModelProperty(value = "一级商品分类名称")
    private String categoryName1;

    @ApiModelProperty(value = "二级商品分类ID")
    private Long categoryId2;

    @ApiModelProperty(value = "二级商品分类名称")
    private String categoryName2;

    @ApiModelProperty(value = "三级商品分类ID")
    private Long categoryId3;

    @ApiModelProperty(value = "三级商品分类名称")
    private String categoryName3;

    @ApiModelProperty(value = "商品ID")
    private Long itemId;

    @ApiModelProperty("商品中心商品id")
    private Long relateItemId;

    @ApiModelProperty(value = "商品编码")
    private String itemCode;

    @ApiModelProperty(value = "商品名称")
    private String itemName;

    @ApiModelProperty(value = "所属公司ID")
    private Long ouId;

    @ApiModelProperty(value = "所属公司编码")
    private String ouCode;

    @ApiModelProperty(value = "所属公司名称")
    private String ouName;

    @ApiModelProperty(value = "主图ID")
    private Long mainPicId;

//    @ApiModelProperty(value = "客户等级价格")
//    private BigDecimal custLevelPrice;

    @ApiModelProperty(value = "图的文件编码")
    private String mainPicFileCode;

    @ApiModelProperty(value = "物料类型")
    private String materiel;

    @ApiModelProperty(value = "商品类型")
    private String type;

    @ApiModelProperty(value = "主图的访问链接")
    private String mainPicUrl;

    @ApiModelProperty(value = "商品SKU")
    private BipItemSkuRespVO itemSkuRespVO;

    @ApiModelProperty(value = "商品图片")
    private BipItemPicRespVO bipItemPicRespVO;

//    @ApiModelProperty(value = "商品规格列表")
//    private List<BipItemSpecRespVO> specList;
//
//    @ApiModelProperty(value = "商品图片列表")
//    private List<BipItemPicRespVO> picList;

    @ApiModelProperty(value = "商品标题")
    private String title;

    @ApiModelProperty(value = "商品属性")
    private String attr;

    @ApiModelProperty(value = "运费收费方式 - 是否包邮")
    private Boolean fareFree;

    @ApiModelProperty(value = "运费模板ID")
    private Long fareTmplId;

    @ApiModelProperty(value = "运费模板ID")
    private BigDecimal fareArm;

    @ApiModelProperty(value = "运费模板编号")
    private String fareTmplCode;

    @ApiModelProperty(value = "运费模板名称")
    private String fareTmplName;

    @ApiModelProperty("商品规格")
    private String itemSpec;

    @ApiModelProperty("计量单位")
    private String uom;

    @ApiModelProperty("客户品牌id")
    private String itmeBrandCode;

    @ApiModelProperty("客户品牌")
    private String itemBrand;
    // SKU信息
    @ApiModelProperty(value = "SKU记录的ID")
    private Long skuId;

    @ApiModelProperty(value = "sku编号")
    private String skuCode;

    @ApiModelProperty(value = "购物车商品折扣id")
    private Long mktDiscountOffsetId;
    @ApiModelProperty(value = "购物车商品折扣明细ID")
    private Long mktDiscountOffsetDId;
    @ApiModelProperty(value = "购物车商品折扣编码")
    private String mktDiscountOffsetCode;

    @ApiModelProperty(value = "购物车满赠折扣id")
    private Long mktDiscountGiftId;
    @ApiModelProperty(value = "购物车满赠折扣明细")
    private Long mktDiscountGiftDId;
    @ApiModelProperty(value = "购物车满赠折扣赠品id")
    private Long mktGiftId;

    @ApiModelProperty(value = "购物车满赠折扣赠品名称")
    private String mktGiftItemName;
//    @ApiModelProperty(value = "购物车商品赠品信息")
//    private BipCartItemGiftRespVO bipCartItemGiftRespVO;

    @ApiModelProperty(value = "购物车商品赠品信息")
    private MktGiftRespVO mktGiftRespVO;

    @ApiModelProperty(value = "购物车商品优惠券信息")
    private BipCouponVO BipCouponVO;
    @ApiModelProperty(value = "购物车商品优惠券Id")
    private Long couponId;


    @ApiModelProperty(value = "折扣优惠金额")
    private BigDecimal mktDiscountOffsetFreeAmt;

    @ApiModelProperty(value = "折扣金额")
    private BigDecimal mktDiscountOffsetAmt;

    @ApiModelProperty(value = "优惠券金额")
    private BigDecimal couponAmt;

    @ApiModelProperty(value = "商品金额")
    private BigDecimal itemAmt;

    @ApiModelProperty(value = "商品基础价格")
    private BigDecimal basePrice;

    @ApiModelProperty(value = "客户价格")
    private BigDecimal custPrice;

    @ApiModelProperty(value = "商品状态，[UDC]SAL:ITEM_STATE", position = 14)
    private String state;

    @ApiModelProperty(value = "客户地址")
    private BipAddressVO bipAddressVO;

    @ApiModelProperty(name = "买赠列表" )
    private List<BipGiftVO> giftList;

    @ApiModelProperty(name = "赠品表id集合")
    private String giftCodes;

}
