package com.elitesland.yst.production.sale.api.vo.resp.shop;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021/08/23
 */
@Data
@ApiModel(description = "商品详细信息")
public class BipItemDetailRespVO implements Serializable {
    private static final long serialVersionUID = -3340561347874447717L;

    @ApiModelProperty(value = "ID")
    private Long id;

    @ApiModelProperty(value = "上架编码", position = 1)
    private String shelfCode;

    @ApiModelProperty(value = "一级商品分类ID", position = 2)
    private Long categoryId1;

    @ApiModelProperty(value = "一级商品分类名称", position = 2)
    private String categoryName1;

    @ApiModelProperty(value = "二级商品分类ID", position = 3)
    private Long categoryId2;

    @ApiModelProperty(value = "二级商品分类名称", position = 3)
    private String categoryName2;

    @ApiModelProperty(value = "三级商品分类ID", position = 4)
    private Long categoryId3;

    @ApiModelProperty(value = "三级商品分类名称", position = 4)
    private String categoryName3;

    @ApiModelProperty(value = "商品ID", position = 5)
    private Long itemId;

    @ApiModelProperty(value = "商品编码", position = 5)
    private String itemCode;

    @ApiModelProperty(value = "商品名称", position = 5)
    private String itemName;

    @ApiModelProperty(value = "所属公司ID", position = 6)
    private Long ouId;

    @ApiModelProperty(value = "所属公司编码", position = 6)
    private String ouCode;

    @ApiModelProperty(value = "所属公司名称", position = 6)
    private String ouName;

    @ApiModelProperty(value = "商品SKU列表", position = 7)
    private List<BipItemSkuRespVO> skuList;

    @ApiModelProperty(value = "商品规格列表", position = 7)
    private List<BipItemSpecRespVO> specList;

    @ApiModelProperty(value = "商品图片列表", position = 8)
    private List<BipItemPicRespVO> picList;

    @ApiModelProperty(value = "商品单位", position = 9)
    private String unit;

    @ApiModelProperty(value = "商品单位名称", position = 9)
    private String unitName;

    @ApiModelProperty(value = "商品标题", position = 10)
    private String title;

    @ApiModelProperty(value = "运费收费方式 - 是否包邮", position = 11)
    private Boolean fareFree;

    @ApiModelProperty(value = "运费模板ID", position = 12)
    private Long fareTmplId;

    @ApiModelProperty(value = "运费模板编号", position = 12)
    private String fareTmplCode;

    @ApiModelProperty(value = "运费模板名称", position = 12)
    private String fareTmplName;

    @ApiModelProperty(value = "商品的图文列表", position = 13)
    private List<BipItemPicContentRespVO> contentPicList;

    @ApiModelProperty(value = "商品状态，[UDC]SAL:ITEM_STATE", position = 14)
    private String state;
}
