package com.elitesland.yst.production.sale.api.vo.resp.shop;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021/09/08
 */
@Data
@ApiModel(description = "商品（SKU）查询结果")
public class BipItemQueryRespVO implements Serializable {
    private static final long serialVersionUID = 5624554838419084877L;

    @ApiModelProperty(value = "B端商品ID", position = 1)
    private Long bipItemId;

    @ApiModelProperty(value = "B端商品SKU的ID", position = 1)
    private Long skuId;

    @ApiModelProperty(value = "一级商品分类ID", position = 2)
    private Long categoryId1;

    @ApiModelProperty(value = "一级商品分类名称", position = 2)
    private String categoryName1;

    @ApiModelProperty(value = "二级商品分类ID", position = 3)
    private Long categoryId2;

    @ApiModelProperty(value = "二级商品分类名称", position = 3)
    private String categoryName2;

    @ApiModelProperty(value = "三级商品分类ID", position = 4)
    private Long categoryId3;

    @ApiModelProperty(value = "三级商品分类名称", position = 4)
    private String categoryName3;

    @ApiModelProperty(value = "商品编码", position = 5)
    private String itemCode;

    @ApiModelProperty(value = "商品名称", position = 6)
    private String itemName;

    @ApiModelProperty(value = "SKU编码", position = 7)
    private String skuCode;

    @ApiModelProperty(value = "SKU名称", position = 8)
    private String skuName;

    @ApiModelProperty(value = "商品ID（商品中心）", position = 9)
    private Long itemId;

    @ApiModelProperty(value = "商品规格", position = 10)
    private List<BipItemSpecRespVO> specList;

    @ApiModelProperty(value = "计量单位", position = 11)
    private String unit;

    @ApiModelProperty(value = "计量单位名称", position = 12)
    private String unitName;

    @ApiModelProperty(value = "基础价", position = 13)
    private BigDecimal price;
}
