package com.elitesland.yst.production.sale.api.vo.resp.shop;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/07/15:57
 * @Description:
 */
@Data
@ApiModel(value = "BipOrderDRespVO", description = "订单明细")
public class BipOrderDRespVO  implements Serializable {

    private static final long serialVersionUID = -8903727818938029276L;

    @ApiModelProperty("订单明细id")
    private Long id;

    @ApiModelProperty("订单明细父id")
    private Long pid;

    @ApiModelProperty("商品类型 ITM：ITEM_TYPE")
    private String itemType;

    @ApiModelProperty("订单id")
    private Long orderId;

    @ApiModelProperty("订单单号")
    private String orderDocNo;

    @ApiModelProperty("商品id")
    private Long itemId;

    @ApiModelProperty("商品SKU id")
    private Long skuId;

    @ApiModelProperty("商品SKU编码")
    private String skuCode;

    @ApiModelProperty(value = "物料类型")
    private String materiel;

    @ApiModelProperty(value = "商品类型")
    private String type;

    @ApiModelProperty("商品中心商品id")
    private Long relateItemId;

    @ApiModelProperty("客户id")
    private Long custId;

    @ApiModelProperty("商品图片id")
    private String itemPicFileCode;

    @ApiModelProperty(value = "商品SKU")
    private BipItemSkuRespVO itemSkuRespVO;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("商品金额")
    private BigDecimal itemAmt;

    @ApiModelProperty("客户标题")
    private String itemTitle;

    @ApiModelProperty("允许退货数量")
    private Long allowBackNum;

    @ApiModelProperty("客户品牌id")
    private Long itmeBrandID;

    @ApiModelProperty(value = "商品属性")
    private String attr;

    @ApiModelProperty("客户品牌")
    private String itemBrand;

    @ApiModelProperty("客户品牌编码")
    private String itmeBrandCode;

    @ApiModelProperty("是否免运费")
    private String freeFare;

    @ApiModelProperty("商品基础价格")
    private BigDecimal basePrice;

    @ApiModelProperty("商品客户价格")
    private BigDecimal custPrice;

    @ApiModelProperty("商品优惠金额")
    private BigDecimal couponAmt;

    @ApiModelProperty("商品折扣抵消金额")
    private BigDecimal discountAmt;

    @ApiModelProperty("在线支付金额")
    private BigDecimal payOnlineAmt;

    @ApiModelProperty("购买数量")
    private Long buyQty;

    @ApiModelProperty("购买时价格")
    private BigDecimal buyAmt;

    @ApiModelProperty("退款时候商品单价")
    private BigDecimal backPrice;

    @ApiModelProperty("运费模板id")
    private Long fareTmplId;

    @ApiModelProperty("运费金额")
    private BigDecimal fareAmt;

    @ApiModelProperty("实付款")
    private BigDecimal payAmt;

    @ApiModelProperty("已付金额")
    private BigDecimal payDoneAmt;

    @ApiModelProperty("计量单位")
    private String uom;

    @ApiModelProperty("退货数量")
    private Long backNum;

    @ApiModelProperty("订单明细状态")
    private String status;

    @ApiModelProperty("物流id")
    private Long logisId;

    @ApiModelProperty("物流单号")
    private String logisNo;

    @ApiModelProperty("商品规格")
    private String itemSpec;



//    @ApiModelProperty("退货物流ID")
//    private Long backLogisId;
//
//    @ApiModelProperty("退货物流单号")
//    private String BackLogisNo;
//
//    @ApiModelProperty("审核时间")
//    private LocalDateTime approveTime;
//
//    @ApiModelProperty("签收时间")
//    private LocalDateTime signTime;
//
//    @ApiModelProperty("审核拒绝原因")
//    private String refuseReason;
//
//
//    @ApiModelProperty("申请退款金额")
//    private BigDecimal applyBackAmt;
//
//    @ApiModelProperty("批准退款金额")
//    private BigDecimal approveBackAmt;
//
//    @ApiModelProperty("审批人id")
//    private BigDecimal approveUserId;
//
//
//    @ApiModelProperty("审批人姓名")
//    private BigDecimal approveUserName;
//
//
//    @ApiModelProperty("退货类型")
//    private String backType;
//
//    @ApiModelProperty("退款时间")
//    private LocalDateTime backPayTime;
//
//    @ApiModelProperty("退货时间")
//    private LocalDateTime backTime;
//
//    @ApiModelProperty("是否需要生成工单")
//    private LocalDateTime isWorkOrder;
//
//    @ApiModelProperty("寄货人姓名")
//    private String shipperName;
//
//    @ApiModelProperty("寄货人电话")
//    private String shipperTel;
//
//    @ApiModelProperty("收货人姓名")
//    private String receiverName;
//
//    @ApiModelProperty("收货人电话")
//    private String receiverTel;


    @ApiModelProperty("优惠券id")
    private Long couponId;

    @ApiModelProperty("优惠券编码")
    private String couponCode;


    @ApiModelProperty("满减折扣id")
    private Long discountOffsetId;

    @ApiModelProperty("满减折扣编码")
    private String discountOffsetCode;

    //zhao.zhi.hao 2021.09.23
    @ApiModelProperty("发票流水号")
    private String invSerialNum;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty(name = "买赠列表" )
    private List<BipGiftVO> giftList;

    @ApiModelProperty(name = "赠品code集合")
    private String giftCodes;

    @ApiModelProperty(name = "赠品列表")
    private List<BriefGiftVO> briefGiftVOS;

    @Data
    public static class BriefGiftVO implements Serializable{

        private static final long serialVersionUID = 6656970229895200934L;

        @ApiModelProperty(value = "商品编码")
        private String itemCode;

        @ApiModelProperty(value = "商品名称")
        private String itemName;
    }
}
