package com.elitesland.yst.production.sale.api.vo.resp.shop;

import com.elitesland.yst.production.sale.api.AmtBigDecimalJsonSerialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * 满减赠折扣-明细VO
 * </p>
 *
 * @author ssy
 * @since 2021/8/19
 */
@ApiModel(description = "满减赠折扣-明细VO")
@Data
public class MktDiscountGiftRespDVO implements Serializable {

    private static final long serialVersionUID = 1289535343676364412L;

    @ApiModelProperty(value = "折扣赠明细表ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty(value = "折扣赠主表ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long mktDiscountGiftId;

    @ApiModelProperty(value = "商品ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty(value = "商品编码")
    private String itemCode;

    @ApiModelProperty(value = "商品名称")
    private String itemName;

    @ApiModelProperty(value = "商品规格")
    private String itemAttr;

    @ApiModelProperty(value = "计量单位")
    private String uom;
    private String uomName;

    @ApiModelProperty(value = "满赠达标金额")
    @JsonSerialize(using = AmtBigDecimalJsonSerialize.class)
    private BigDecimal limitAmt;

    @ApiModelProperty(value = "满赠达标数量")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long limitNum;

}
