package com.elitesland.yst.production.sale.api.vo.save;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/5/31 13:36
 */
@Data
@ApiModel(description = "客户信息导入数据")
public class CrmCustImportSaveVO implements Serializable {

    private static final long serialVersionUID = -2807040183072636335L;
    @ApiModelProperty(value = "客户编码", required = true)
    @NotBlank(message = "客户状态不得为空")
    private String custCode;

    @ApiModelProperty(value = "客户名称", required = true)
    @NotBlank(message = "客户状态不得为空")
    private String custName;

    @ApiModelProperty(value = "简称")
    private String custAbbr;

    @ApiModelProperty(value = "英文名称")
    private String custName2;

    @ApiModelProperty(value = "外部系统客户编码")
    private String custCode2;

    @ApiModelProperty(value = "税务登记号")
    private String taxRegNo;

    @ApiModelProperty(value = "工商登记号")
    private String icRegisterNo;

    @ApiModelProperty(value = "公司", required = true)
    @NotBlank(message = "公司不得为空")
    private Long ouId;
    private String ouCode;

    @ApiModelProperty(value = "公司名称", required = true)
    @NotBlank(message = "公司名称不得为空")
    private String ouName;

    @ApiModelProperty(value = "销售组织", required = true)
    @NotBlank(message = "销售组织不得为空")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;
    private String buCode;
    private String buName;

    @ApiModelProperty(value = "区域", required = true)
    @NotBlank(message = "区域不得为空")
    private String region;

    @JsonSerialize(using = ToStringSerializer.class)
    private Long agentEmpId;

    @ApiModelProperty(value = "业务员名称", required = true)
    @NotBlank(message = "业务员名称不得为空")
    private String agentEmpName;

    @ApiModelProperty(value = "业务员编码", required = true)
    @NotBlank(message = "业务员编码不得为空")
    private String agentEmpCode;

    @ApiModelProperty(value = "客户分类", required = true)
    @NotBlank(message = "客户分类不得为空")
    private String custType;

    @ApiModelProperty(value = "客户状态", required = true)
    @NotBlank(message = "客户状态不得为空")
    private String custStatus;

    @ApiModelProperty(value = "客户等级")
    private String custLevel;

    @ApiModelProperty(value = "客户行业")
    private String custIndustry;

    @ApiModelProperty(value = "客户来源")
    private String custSource;

    @ApiModelProperty(value = "客户规模")
    private String compScale;

    @ApiModelProperty(value = "客户归类")
    private String custType2;

    @ApiModelProperty(value = "客户年营")
    private String compTurnover;

    @ApiModelProperty(value = "开票类型")
    private String invType;

    @ApiModelProperty(value = "税号")
    private String taxerNo;

    @ApiModelProperty(value = "单位地址")
    private String invAddress;

    @ApiModelProperty(value = "开票电话")
    private String invTel;

    @ApiModelProperty(value = "开票抬头")
    private String invTitle;

    @ApiModelProperty(value = "开户银行")
    private String invBankName;

    @ApiModelProperty(value = "开户银行")
    private String invBankAcc;

    @ApiModelProperty(value = "联系人")
    private String invPicName;

    @ApiModelProperty(value = "联系人电话")
    private String invPicPhone;

    @ApiModelProperty(value = "付款条款")
    private String paymentTerm;

    @ApiModelProperty(value = "账期检查类型")
    private String ardaysCheckType;

    @ApiModelProperty(value = "信贷检查类型")
    private String creditCheckType;

    @ApiModelProperty(value = "信贷额度")
    private String creditLimit;

    @ApiModelProperty(value = "默认税率编码", required = true)
    @NotBlank(message = "默认税率编码不得为空")
    private String taxRateNo;

    private BigDecimal taxRate;

    @ApiModelProperty(value = "财务属性")
    private String financialAttribute;

    @ApiModelProperty(value = "财务属性2")
    private String financialAttribute2;

    @ApiModelProperty(value = "财务属性3")
    private String financialAttribute3;

    @ApiModelProperty(value = "财务属性4")
    private String financialAttribute4;

    @ApiModelProperty(value = "大B/小B")
    private String custGroup2;

    @ApiModelProperty(value = "类别码")
    private String cat;

    @ApiModelProperty(value = "类别码2")
    private String cat2;

    @ApiModelProperty(value = "类别码3")
    private String cat3;

    @ApiModelProperty(value = "类别码4")
    private String cat4;

    @ApiModelProperty(value = "类别码5")
    private String cat5;

    @ApiModelProperty(value = "类别码6")
    private String cat6;

    @ApiModelProperty(value = "类别码7")
    private String cat7;

    @ApiModelProperty(value = "类别码8")
    private String cat8;

    @ApiModelProperty(value = "类别码9")
    private String cat9;

    @ApiModelProperty(value = "类别码10")
    private String cat10;

//    @ApiModelProperty(value = "参保信息")
//    private String insured;


}
