package com.elitesland.yst.production.sale.api.vo.save;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author Chris
 * @date 2021-03-10
 */
@Data
public class OrgAddrBankAccSaveVO implements Serializable {

    private static final long serialVersionUID = -1281707009056763307L;

    /**
     * id
     */
    @ApiModelProperty("id")
    private Long id;


    /**
     * 数据来源
     */
    @ApiModelProperty("数据来源")
    private String dataSource;

    /**
     * 账号类型:[UDC]ORG:ADDR_BANKACC_TYPE
     */
    @ApiModelProperty("账号类型:[UDC]ORG:ADDR_BANKACC_TYPE")
    private String accType;

    /**
     * 是否默认：1是，0否
     */
    @ApiModelProperty("是否默认：1是，0否")
    private Boolean defaultFlag;

    /**
     * 银行ID
     */
    @ApiModelProperty("银行ID")
    private Long bankId;

    /**
     * 银行编号
     */
    @ApiModelProperty("银行编号")
    private String bankCode;

    /**
     * 银行名称
     */
    @ApiModelProperty("银行名称")
    private String bankName;

    /**
     * 网点名称
     */
    @ApiModelProperty("网点名称")
    private String branchName;

    /**
     * 开户行账号
     */
    @ApiModelProperty("开户行账号")
    private String bankAcc;

    /**
     * 开户人姓名
     */
    @ApiModelProperty("开户人姓名")
    private String holderName;

    /**
     * 币种
     */
    @ApiModelProperty("币种")
    private String currCode;


    /**
     * 第三方虚拟用户ID
     */
    @ApiModelProperty(value = "第三方虚拟用户ID")
    private String thirdpartyVirtualUserId;


    /**
     * 第三方虚拟帐户
     */
    @ApiModelProperty(value = "第三方虚拟帐户")
    private String thirdpartyVirtualAcc;

}
