package com.elitesland.yst.production.sale.api.vo.save.exter;

import com.elitescloud.boot.model.entity.BaseModel;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/10/9 14:40
 */
@Data
@ApiModel(description = "销售合同保存")
public class SalContractDSaveDTO extends BaseModel implements Serializable {
    private static final long serialVersionUID = 1044688137065630907L;

    @ApiModelProperty("主表ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long masId;

    @ApiModelProperty("行号")
    private BigDecimal lineNo;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("数量")
    private BigDecimal qty;

    @ApiModelProperty("含税价格")
    private BigDecimal price;

    @ApiModelProperty("计量单位")
    private String uom;

    @ApiModelProperty("含税金额")
    private BigDecimal amt;
}
