package com.elitesland.yst.production.sale.api.vo.save.shop;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021/08/27
 */
@Data
@ApiModel(description = "最小起订量")
public class BipItemLimitBuySaveVO implements Serializable {
    private static final long serialVersionUID = 8587986179119611224L;

    @ApiModelProperty(value = "商品记录ID", required = true, position = 1)
    @NotEmpty(message = "请选择商品")
    private List<Long> idList;

    @ApiModelProperty(value = "最小起订量", required = true, position = 2)
    @NotNull(message = "最小起订量不能为空")
    @Min(value = 1, message = "最小起订量不能小于1")
    private Integer limitBuy;
}
