package com.elitesland.yst.production.sale.api.vo.save.shop;

import com.elitesland.yst.production.sale.api.vo.resp.shop.BipOrderDRespVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/07/15:35
 * @Description:
 */
@Data
public class BipOrderSaveVO implements Serializable {

    private static final long serialVersionUID = 4741529115489679632L;

    @ApiModelProperty("订单ID")
    private Long id;

    @ApiModelProperty("订单号")
    private String docNo;

    @ApiModelProperty("退货单号")
    private String backDocNo;

    @ApiModelProperty("客户id")
    private Long custId;

    @ApiModelProperty("应付金额")
    private BigDecimal payAmt;
    @ApiModelProperty("已付金额")
    private BigDecimal payDoneAmt;

    @ApiModelProperty("订单总金额")
    private BigDecimal totalAmt;

    @ApiModelProperty("商品总金额")
    private BigDecimal itemAmt;

    @ApiModelProperty("运费总金额")
    private BigDecimal fareAmt;


    @ApiModelProperty("运费最终金额")
    private BigDecimal fareFinalAmt;

    @ApiModelProperty("优惠券抵扣金额")
    private BigDecimal couponAmt;

    @ApiModelProperty("促销抵扣金额")
    private BigDecimal discountAmt;

    @ApiModelProperty("积分抵扣金额")
    private BigDecimal scoreAmt;

    @ApiModelProperty("下单时间")
    private LocalDateTime orderTime;


    @ApiModelProperty("支付方式Id")
    private String payMethodId;

    @ApiModelProperty("支付方式名称")
    private String payMethodName;

    @ApiModelProperty("订单状态")
    private String status;

    @ApiModelProperty("付款状态")
    private String payStatus;

    @ApiModelProperty("支付时间")
    private LocalDateTime payTime;

    @ApiModelProperty("支付记录ID")
    private String payRecordId;

    @ApiModelProperty("是否开票")
    private String invoice;

    @ApiModelProperty("发票id")
    private Long invoiceId;

    @ApiModelProperty("收货地址")
    private Long addressId;

    @ApiModelProperty("订单交付id")
    private Long deliveId;

    @ApiModelProperty("订单交付时间")
    private LocalDateTime deliveTime;


    @ApiModelProperty("订单完成时间")
    private LocalDateTime finishTime;

    @ApiModelProperty("是否评价 0 未评价 1 评价")
    private Boolean isEval;

    @ApiModelProperty("订单评价时间")
    private LocalDateTime evalTime;


    @ApiModelProperty("订单交付状态")
    private String deliveStatus;

    @ApiModelProperty("要求发货时间")
    private LocalDateTime demandTime;

    @ApiModelProperty("订单明细")
    private List<BipOrderDRespVO> orderDList;

    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("收货地址id")
    private Long adressId ;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("物流评分")
    private String logicEvalScore;

    @ApiModelProperty("服务评分")
    private String serverEvalScore;



}
