package com.elitesland.yst.production.sale.rpc;

import com.elitesland.yst.production.sale.Application;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmCustSimpleVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.LmSaveCustRespVO;
import com.elitesland.yst.production.sale.rpc.param.CustAgentInfoRpcDTO;
import com.elitesland.yst.production.sale.rpc.param.CustAndAgentDTO;
import com.elitesland.yst.production.sale.rpc.param.CustAndBelongOuDTO;
import com.elitesland.yst.production.sale.rpc.param.CustBaseInfo;
import com.elitesland.yst.production.sale.rpc.param.CustLegalRepreRpcDTO;
import com.elitesland.yst.production.sale.rpc.param.PartnerInvRpcDTO;
import com.elitesland.yst.production.sale.rpc.param.SalesmanStoreDTO;
import com.elitesland.yst.production.sale.rpc.param.query.CustAndBelongOuQueryDTO;
import com.elitesland.yst.production.sale.rpc.param.query.CustBaseQueryDTO;
import com.elitesland.yst.production.sale.rpc.param.query.PartnerInvQueryDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(name = Application.NAME, path = LmCustRpcService.URI)
public interface LmCustRpcService {

    String URI = Application.URI_PREFIX + "/custlm";


    @GetMapping("/getInvCustCode")
    List<String> getInvCustCodes(@RequestParam("userName") Long userId);


    @GetMapping("/findInvCust")
    List<LmSaveCustRespVO> findInvCust(@RequestParam("custCode") String custCode);

    @GetMapping("/getCustSimple")
    CrmCustSimpleVO getCustSimple(@RequestParam("userName") String userName);

    @GetMapping("/getCustSimpleByUserId")
    CrmCustSimpleVO getCustSimpleByUserId(@RequestParam("userId") Long userId);

    @PostMapping("/getCustAndBelongOu")
    List<CustAndBelongOuDTO> getCustAndBelongOu(@RequestBody CustAndBelongOuQueryDTO custAndBelongOuQueryDTO);


    @GetMapping("/isCancelCustFlag")
    Boolean isCancelCustFlag(@RequestParam("custCode") String custCode);

    @GetMapping("/isDesExists")
    Boolean isDesExists(@RequestParam("desId")Long desId);




    @GetMapping("/getCustAgent")
    List<CustAgentInfoRpcDTO> getCustAgent(@RequestParam("custCodes") List<String> custCodes);



    @PostMapping("/getCustAgentPost")
    List<CustAgentInfoRpcDTO> getCustAgentPost(@RequestBody List<String> custCodes);


    @PostMapping("/getPartnerInvCust")
    List<PartnerInvRpcDTO> getPartnerInvCust(@RequestBody PartnerInvQueryDTO partnerInvQueryDTO);


    @PostMapping("/getCustAndAgent")
    List<CustAndAgentDTO> getCustAndAgent(@RequestBody CustBaseQueryDTO custBaseQueryDTO);

    @GetMapping("/querySalesmanStore")
    List<SalesmanStoreDTO> querySalesmanStore(@RequestParam("empCode") String empCode);

    @PostMapping("/queryType")
    List<CustBaseInfo> queryCustType(@RequestBody List<String> custCodes);

    /**
     * @description: 根据父级客户编码获取子项编码
     * @param:  parentCustCode  父级客户编码
     * @return: List<String> 返回子客户编码
     * @author zhengyue
     * @date: 2023/12/6 13:53
     */
    @GetMapping("/getCustCodeByParent")
    List<String> getCustCodeByParent(@RequestParam("parentCustCode2") String parentCustCode2);

    /** 
     * @description: 根据法人名称或客户号查询关系
     * @param:  legalRepre 法人
     * @return:  List<String> 客户号
     * @author zhengyue
     * @date: 2023/12/7 8:46
     */
    @GetMapping("/getCustCode2ByLegalRepre")
    List<CustLegalRepreRpcDTO> getCustCode2ByLegalRepre(@RequestParam("legalRepre") String legalRepre,
                                                        @RequestParam("custCode2") String custCode2);
}
