package com.elitesland.yst.production.sale.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.sale.Application;
import com.elitesland.yst.production.sale.dto.query.SalInvApplyCheckDTO;
import com.elitesland.yst.production.sale.dto.query.SalReceiptCheckDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * @auther JinXK
 * @date 2021/8/26 11:08
 */
@FeignClient(name = Application.NAME, path = SalReceiptRpcService.URI)
public interface SalReceiptRpcService {
    String URI = Application.URI_PREFIX + "/receipt";
	@PostMapping("/salReceiptRpc/updateReceiptStatus")
    ApiResult<Object> updateReceiptStatus(SalReceiptCheckDTO receiptCheckDTO);

	@PostMapping("/salReceiptRpc/updateInvApplyStatus")
    ApiResult<Object> updateInvApplyStatus(SalInvApplyCheckDTO salInvApplyCheckDTO);
}
