package com.elitesland.yst.production.sale.controller.crm;

import com.elitesland.yst.production.sale.api.service.CrmScustService;
import com.elitesland.yst.production.sale.api.vo.param.crm.CrmEmpAssignParamVO;
import com.elitesland.yst.production.sale.api.vo.param.crm.CrmScustQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmScustDetailRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmScustPageRespVO;
import com.elitesland.yst.production.sale.api.vo.save.CrmScustImportSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.CrmScustSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.SalConRecvImportSaveVO;
import com.elitesland.yst.production.sale.controller.BaseController;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/6/4 13:12
 */
@RestController
@RequestMapping(value = "/crm/scust", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(tags = "潜在客户信息")
@ApiSupport(author = "zhao.zhi.hao", order = 1)
@Slf4j
public class CrmScustController extends BaseController {

    @Autowired
    private CrmScustService crmScustService;

    @PostMapping(value = "/search")
    @ApiOperation(value = "分页查询潜在客户列表")
    @ApiOperationSupport(order = 1)
    public ApiResult<PagingVO<CrmScustPageRespVO>> search(@RequestBody CrmScustQueryParamVO searchParam) {
        return ApiResult.ok(crmScustService.search(searchParam));
    }

    @PostMapping(value = "/get/{id}")
    @ApiOperation(value = "查询潜在客户详细信息")
    @ApiOperationSupport(order = 2)
    public ApiResult<CrmScustDetailRespVO> getScustDetail(@PathVariable Long id) {
        return ApiResult.ok(crmScustService.findScustById(id));
    }

    @PostMapping(value = "/empAssign")
    @ApiOperation(value = "批量分配业务员")
    @ApiOperationSupport(order = 3)
    public ApiResult<Object> empAssign(@RequestBody CrmEmpAssignParamVO crmEmpAssignParamVO) {
        crmScustService.empAssign(crmEmpAssignParamVO);
        return ApiResult.ok();
    }

    @PostMapping(value = "/save")
    @ApiOperation(value = "潜在客户保存")
    @ApiOperationSupport(order = 4)
    public ApiResult<Long> save(@RequestBody CrmScustSaveVO saveVO) {
        CrmScustDetailRespVO scustDetailRespVO = crmScustService.save(saveVO).getData();
        return ApiResult.ok(scustDetailRespVO.getId());
    }

    @GetMapping(value = "/updateStatus/{id}")
    @ApiOperation(value = "更改潜在客户状态")
    @ApiOperationSupport(order = 4)
    public ApiResult<Long> updateScustStatus(@PathVariable Long id) {
        return ApiResult.ok(crmScustService.updateScustStatus(id));
    }

    @PostMapping(value = "/ImportScustData")
    @ApiOperation(value = "导入潜在客户信息数据")
    @ApiOperationSupport(order = 6)
    public ApiResult<Object> parseImportScustData(MultipartFile file) {
        List<CrmScustImportSaveVO> parseData = null;
        try {
            parseData = (List<CrmScustImportSaveVO>) this.importExcel(file, CrmScustImportSaveVO.class, 3, 3);
        } catch (Exception e) {
            return ApiResult.fail("解析导入文件失败，请严格按照原始模板数据格式进行导入");
        }
        if (!CollectionUtils.isEmpty(parseData)) {
            return crmScustService.conScustImportData(parseData);
        }
        return ApiResult.ok();
    }
}
