package com.elitesland.yst.production.sale.controller.record;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.service.ExectRecordTempService;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.ExectRecordTempQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.ExectRecordTempRespVO;
import com.elitesland.yst.production.sale.api.vo.save.ExectRecordTempSaveVO;
import com.elitesland.yst.production.sale.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 执行记录模板管理
 * @author wz
 * @date 2021-06-16 14:43:45
 */


@RestController
@RequestMapping(value = "/temp", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(value = "执行记录模板管理", tags = {"执行记录模板管理"})
@RequiredArgsConstructor
public class ExecutionRecordTemController extends BaseController {

    private final ExectRecordTempService exectRecordTempService;

    @PostMapping(value = "/save")
    @ApiOperation(value = "执行记录模板-新增/修改")
    public ApiResult<Long> save(@RequestBody ExectRecordTempSaveVO saveVO) {
       Long id = exectRecordTempService.save(saveVO);
        return ApiResult.ok(id);
    }

    @PostMapping(value = "/query")
    @ApiOperation(value = "执行记录模板-分页查询")
    public ApiResult<PagingVO<ExectRecordTempRespVO>> query(@RequestBody ExectRecordTempQueryVO param) {
        PagingVO<ExectRecordTempRespVO> respVOPackage=exectRecordTempService.query(param);
        return ApiResult.ok(respVOPackage);
    }

    @PostMapping(value = "/queryDtl")
    @ApiOperation(value = "执行记录模板-明细查询")
    public ApiResult<ExectRecordTempRespVO> queryDtl(@RequestBody ExectRecordTempQueryVO param) {
        ExectRecordTempRespVO exectRecordTempRespVO = exectRecordTempService.queryDtl(param);
        return ApiResult.ok(exectRecordTempRespVO);
    }

    @GetMapping(value = "/open")
    @ApiOperation(value = "执行记录模板-启用")
    public ApiResult open(@RequestParam("id") Long id) {
        exectRecordTempService.open(id);
        return ApiResult.ok();
    }

    @GetMapping(value = "/stop")
    @ApiOperation(value = "执行记录模板-停用")
    public ApiResult stop(@RequestParam("id") Long id) {
        exectRecordTempService.stop(id);
        return ApiResult.ok();
    }


    @GetMapping(value = "/findByOuAndType")
    @ApiOperation(value = "执行记录模板-根据公司编码+任务类型查询模板")
    public ApiResult stop(@RequestParam("taskType")String taskType ,@RequestParam("ouCode")String ouCode) {
        List<ExectRecordTempRespVO> exectRecordTempRespVOS = exectRecordTempService.queryByCodeAndTask(taskType, ouCode);
        return ApiResult.ok(exectRecordTempRespVOS);
    }


    @PostMapping(value = "/queryByCode")
    @ApiOperation(value = "执行记录模板-根据编码查询")
    public ApiResult<ExectRecordTempRespVO> queryByCode(@RequestParam("code") String code) {
        ExectRecordTempRespVO exectRecordTempRespVO = exectRecordTempService.queryByCode(code);
        return ApiResult.ok(exectRecordTempRespVO);
    }



}
