package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

@Entity
@Table(name = "bip_coupon_index_img", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "bip_coupon_index_img", comment = "小程序首页弹出优惠券背景图片")
@EnableJpaAuditing
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class BipCouponIndexImgDO extends BaseModel implements Serializable {

    @ApiModelProperty("fileCode")
    @Column(name = "file_code", columnDefinition = "varchar(64)  comment 'fileCode'")
    private String fileCode;

    @ApiModelProperty("fileSize")
    @Column(name = "file_size", columnDefinition = "varchar(256)  comment 'fileSize'")
    private String fileSize;

    @ApiModelProperty("fileType")
    @Column(name = "file_type", columnDefinition = "varchar(64)  comment 'fileType'")
    private String fileType;

    @ApiModelProperty("height")
    @Column(name = "height", columnDefinition = "bigint(18)  comment 'height'")
    private Long height;

    @ApiModelProperty("mimeType")
    @Column(name = "mime_type", columnDefinition = "varchar(64)  comment 'mimeType'")
    private String mimeType;

    @ApiModelProperty("originalName")
    @Column(name = "original_name", columnDefinition = "varchar(64)  comment 'originalName'")
    private String originalName;

    @ApiModelProperty("suffix")
    @Column(name = "suffix", columnDefinition = "varchar(64)  comment 'suffix'")
    private String suffix;

    @ApiModelProperty("uploadTime")
    @Column(name = "upload_time", columnDefinition = "varchar(64)  comment 'uploadTime'")
    private String uploadTime;

    @ApiModelProperty("url")
    @Column(name = "url", columnDefinition = "varchar(256)  comment 'url'")
    private String url;

    @ApiModelProperty("urlDelete")
    @Column(name = "url_delete", columnDefinition = "varchar(256)  comment 'urlDelete'")
    private String urlDelete;

    @ApiModelProperty("urlDownload")
    @Column(name = "url_download", columnDefinition = "varchar(256)  comment 'urlDownload'")
    private String urlDownload;

    @ApiModelProperty("urlPreview")
    @Column(name = "url_preview", columnDefinition = "varchar(256)  comment 'urlPreview'")
    private String urlPreview;

    @ApiModelProperty("width")
    @Column(name = "width", columnDefinition = "bigint(18)  comment 'width'")
    private Long width;

    @ApiModelProperty("ouId")
    @Column(name = "ou_id", columnDefinition = "bigint(18)  comment 'ouId'")
    private Long ouId;

    @ApiModelProperty("ouName")
    @Column(name = "ou_name", columnDefinition = "varchar(256)  comment 'ouName'")
    private String ouName;

}
