package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/04/14:01
 * @Description:
 */
@Entity
@Table(name = "bip_fare_tmpl_d")
@org.hibernate.annotations.Table(appliesTo = "bip_fare_tmpl_d", comment = "运费模板详情")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")

public class BipFareTmplDDo extends BaseModel implements Serializable {

    private static final long serialVersionUID = -2251467100033439721L;

    @Column(name = "lin_no", columnDefinition = "int(10) comment '行号'")
    private Integer linNo;

    @Column(name = "method", columnDefinition = "varchar(20) comment '方式'")
    private String method;


    @Column(name = "areas", columnDefinition = "varchar(1024) comment '区域'")
    private String areas;

    @Column(name = "default_num", columnDefinition = "bigInt(20) comment '默认件数'")
    private Long defaultNum;

    @Column(name = "default_fee", columnDefinition = "decimal(20,2) comment '默认件数'")
    private BigDecimal defaultFee;


    @Column(name = "inc_num", columnDefinition = "bigInt(20) comment '增加数量'")
    private Long incNum;

    @Column(name = "inc_fee", columnDefinition = "decimal(20,2) comment '增加运费'")
    private Long incFee;
}
