package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/04/15:24
 * @Description: 意见反馈
 */

@Entity
@Table(name = "bip_feed_backe")
@org.hibernate.annotations.Table(appliesTo = "bip_feed_backe", comment = "意见反馈")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")

public class BipFeedBackDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -2617326230510422048L;

    @Column(name = "cust_account_id", columnDefinition = "varchar(20) comment '账户ID'")
    private String custAccountId;

    @Column(name = "cust_account_name", columnDefinition = "varchar(64) comment '账户名称'")
    private String custAccountName;

    @Column(name = "tel", columnDefinition = "varchar(64) comment '账户绑定手机号'")
    private String tel;

    @Column(name = "replay", columnDefinition = "varchar(20) comment '是否已回复'")
    private String replay;

    @Column(name = "replay_Account_id", columnDefinition = "varchar(20) comment '回复者id'")
    private String replayAccountId;

    @Column(name = "replay_account_name", columnDefinition = "varchar(20) comment '回复者名称'")
    private String replayAccountName;

    @Column(name = "replay_context", columnDefinition = "varchar(1024) comment '回复内容'")
    private String replayContext;

    @Column(name = "replay_time", columnDefinition = "datetime comment '回复时间'")
    private LocalDateTime replayTime;

    @Column(name = "context", columnDefinition = "varchar(1024) comment '意见内容'")
    private String context;
    @Column(name = "file_codes", columnDefinition = "varchar(1024) comment '意见反馈图片'")
    private String fileCodes;
}
