package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: ssy
 * @Date: 2021/08/17
 * @Description:满减折扣详情实体类
 */
@Entity
@Table(name = "mkt_discount_offset_d")
@org.hibernate.annotations.Table(appliesTo = "mkt_discount_offset_d", comment = "满减折扣详情表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class MktDiscountOffsetDDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -6110605620472381215L;

    @Column(name = "mkt_discount_offset_id", columnDefinition = "bigInt(20)   comment '折扣满减id'")
    private Long mktDiscountOffsetId;

    @Column(name = "item_id", columnDefinition = "bigInt(20)   comment '商品id'")
    private Long itemId;

    @Column(name = "item_code", columnDefinition = "varchar(40)   comment '商品code'")
    private String itemCode;

    @Column(name = "item_name", columnDefinition = "varchar(255)   comment '商品名称'")
    private String itemName;

    @Column(name = "item_attr", columnDefinition = "varchar(255)   comment '商品规格'")
    private String itemAttr;

    @Column(name = "uom", columnDefinition = "varchar(40)   comment '计量单位'")
    private String uom;

    @Column(name = "limit_amt", columnDefinition = "decimal(20,2)   comment '满减达标金额'")
    private BigDecimal limitAmt;

    @Column(name = "limit_num", columnDefinition = "bigInt(20)   comment '满减达标数量'")
    private Long limitNum;

    @Column(name = "base_price", columnDefinition = "decimal(20,4)   comment '基础价格'")
    private BigDecimal basePrice;

    @Column(name = "cuse_price", columnDefinition = "decimal(20,4)   comment '客户价格'")
    private BigDecimal custPrice;

    @Column(name = "free_amt", columnDefinition = "decimal(20,2)   comment '减免金额'")
    private BigDecimal freeAmt;

    @Column(name = "discount_price", columnDefinition = "decimal(20,4)   comment '折扣后价格'")
    private BigDecimal discountPrice;

}
