package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.boot.common.convert.BooleanToIntegerConverter;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/6/8 8:07 下午
 */
@Entity
@Table(name = "sal_contract")
@org.hibernate.annotations.Table(appliesTo = "sal_contract", comment = "销售合同")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class SalContractDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = 3157453116257302549L;

    @ApiModelProperty(value = "公司ID")
    @Column(name = "ou_id", columnDefinition = "bigint(20) default null  comment '公司ID'")
    private Long ouId;

    @ApiModelProperty("合同编号")
    @Column(name = "contract_no", columnDefinition = "varchar(40) comment '合同编号'")
    private String contractNo;

    @ApiModelProperty("外部合同编号")
    @Column(name = "contract_no2", columnDefinition = "varchar(60) comment '外部合同编号'")
    private String contractNo2;

    @ApiModelProperty("合同类型")
    @Column(name = "contract_type", columnDefinition = "varchar(40) comment '合同类型 [UDC]SAL:CONTRACT_TYPE'")
    private String contractType;

    @ApiModelProperty("合同状态")
    @Column(name = "contract_status", columnDefinition = "varchar(40) comment '合同状态 [UDC]SAL:CONTRACT_STATUS'")
    private String contractStatus;

    @ApiModelProperty("合同名称")
    @Column(name = "contract_name", columnDefinition = "varchar(200) comment '合同名称'")
    private String contractName;

    @ApiModelProperty("合同版本")
    @Column(name = "contract_version", columnDefinition = "int(18) comment '合同版本'")
    private Integer contractVersion;

    @ApiModelProperty("项目名称")
    @Column(name = "proj_name", columnDefinition = "varchar(200) comment '项目名称'")
    private String projName;

    @ApiModelProperty("项目id")
    @Column(name = "proj_id", columnDefinition = "bigint(20) comment '项目id'")
    private Long projId;

    @ApiModelProperty("项目编码")
    @Column(name = "proj_code", columnDefinition = "varchar(200) comment '项目编码'")
    private String projCode;

    @ApiModelProperty("CRM项目编码")
    @Column(name = "proj_code2", columnDefinition = "varchar(200) comment 'CRM项目编码'")
    private String projCode2;

    @ApiModelProperty("合同质保期 数字N年")
    @Column(name = "guarantee_period", columnDefinition = "varchar(10) comment '合同质保期'")
    private String guaranteePeriod;

    @ApiModelProperty("城市")
    @Column(name = "contract_city", columnDefinition = "varchar(40) comment '城市'")
    private String contractCity;

    @ApiModelProperty("交付详细地址")
    @Column(name = "deliver_address", columnDefinition = "varchar(200) comment '交付详细地址'")
    private String deliverAddress;

    @ApiModelProperty("审批意见")
    @Column(name = "appr_comment", columnDefinition = "varchar(200) comment '审批意见'")
    private String apprComment;

    @ApiModelProperty(value = "交货时间")
    @Column(name = "deliver_date", columnDefinition = "datetime comment '交货时间'")
    private LocalDate deliverDate;

    @ApiModelProperty("费用承担方")
    @Column(name = "fee_carrier", columnDefinition = "varchar(40) comment '费用承担方 [UDC]SAL:FREIGHT_ON'")
    private String feeCarrier;

    @ApiModelProperty("产品安装")
    @Column(name = "install_flag", columnDefinition = "varchar(40) comment '产品安装 [UDC]SAL:INSTALL_TYPE'")
    private String installFlag;

    @ApiModelProperty(value = "签约日期")
    @Column(name = "sign_date", columnDefinition = "datetime comment '签约日期'")
    private LocalDate signDate;

    @ApiModelProperty(value = "开始日期")
    @Column(name = "begin_date", columnDefinition = "datetime comment '开始日期'")
    private LocalDate beginDate;

    @ApiModelProperty(value = "结束日期")
    @Column(name = "end_date", columnDefinition = "datetime comment '开始日期'")
    private LocalDate endDate;

    @ApiModelProperty("合同总金额")
    @Column(name = "total_amt", columnDefinition = "decimal(20,8) comment '合同总金额'")
    private BigDecimal totalAmt;

    @ApiModelProperty("币种")
    @Column(name = "curr_code", columnDefinition = "varchar(10) comment '币种'")
    private String currCode;

    @ApiModelProperty("合同质保金")
    @Column(name = "guarantee_amt", columnDefinition = "decimal(20,8) comment '合同质保金'")
    private BigDecimal guaranteeAmt;

    @ApiModelProperty("是否需要项目验收")
    @Column(name = "proj_confirm_flag", columnDefinition = "tinyint(1) comment '是否需要项目验收'")
    @Convert(converter = BooleanToIntegerConverter.class)
    private Boolean projConfirmFlag;

    @ApiModelProperty("签约背景")
    @Column(name = "sign_background", columnDefinition = "varchar(200) comment '签约背景'")
    private String signBackground;

    @ApiModelProperty("配送方式")
    @Column(name = "deliver_method", columnDefinition = "varchar(40) comment '配送方式 [UDC]SAL:SO_DELIVER_METHOD'")
    private String deliverMethod;

    @ApiModelProperty("运输方式")
    @Column(name = "trans_type", columnDefinition = "varchar(40) comment '运输方式 [UDC]COM:TP_TYPE'")
    private String transType;

    @ApiModelProperty("运输温层")
    @Column(name = "transport_temp", columnDefinition = "varchar(40) comment '运输温层 [UDC]INV:TEMP_TYPE'")
    private String transportTemp;

    @ApiModelProperty("客户ID")
    @Column(name = "cust_id", columnDefinition = "bigint(20) comment '客户ID'")
    private Long custId;

    @ApiModelProperty("客户编号")
    @Column(name = "cust_code", columnDefinition = "varchar(40) comment '客户编号'")
    private String custCode;

    @ApiModelProperty("客户名称")
    @Column(name = "cust_name", columnDefinition = "varchar(200) comment '客户名称'")
    private String custName;

    @ApiModelProperty("客户联系人")
    @Column(name = "cust_pic", columnDefinition = "varchar(40) comment '客户联系人'")
    private String custPic;

    @ApiModelProperty("客户联系人电话")
    @Column(name = "cust_pic_tel", columnDefinition = "varchar(20) comment '客户联系人电话'")
    private String custPicTel;

    @ApiModelProperty("客户地址")
    @Column(name = "cust_address", columnDefinition = "varchar(200) comment '客户地址'")
    private String custAddress;

    @ApiModelProperty("签约公司")
    @Column(name = "b_sign_ou", columnDefinition = "varchar(64) comment '签约公司'")
    private String bSignOu;

    @ApiModelProperty("签约部门")
    @Column(name = "b_sign_dept", columnDefinition = "varchar(40) comment '签约部门'")
    private String bSignDept;

    @ApiModelProperty("区域")
    @Column(name = "b_region", columnDefinition = "varchar(40) comment '区域'")
    private String bRegion;

    @ApiModelProperty("销售员")
    @Column(name = "b_salesman", columnDefinition = "varchar(40) comment '销售员'")
    private String bSalesman;

    @ApiModelProperty("销售员电话")
    @Column(name = "b_salesman_tel", columnDefinition = "varchar(20) comment '销售员电话'")
    private String bSalesmanTel;

    @ApiModelProperty("签约公司地址")
    @Column(name = "b_address", columnDefinition = "varchar(200) comment '签约公司地址'")
    private String bAddress;

    @ApiModelProperty("丙方编码")
    @Column(name = "c_code", columnDefinition = "varchar(64) comment '丙方编码'")
    private String cCode;

    @ApiModelProperty("丙方名称")
    @Column(name = "c_name", columnDefinition = "varchar(40) comment '丙方名称'")
    private String cName;

    @ApiModelProperty("丙方地址")
    @Column(name = "c_address", columnDefinition = "varchar(200) comment '丙方地址'")
    private String cAddress;

    @ApiModelProperty("丙方联系人")
    @Column(name = "c_contact", columnDefinition = "varchar(20) comment '丙方联系人'")
    private String cContact;

    @ApiModelProperty("丙方联系人电话")
    @Column(name = "c_contact_tel", columnDefinition = "varchar(20) comment '丙方联系人电话'")
    private String cContactTel;

    @ApiModelProperty("来源单据类型")
    @Column(name = "root_doc_type", columnDefinition = "varchar(200) comment '来源单据类型'")
    private String rootDocType;

    @ApiModelProperty("来源单据ID")
    @Column(name = "root_doc_id", columnDefinition = "bigint(20) comment '来源单据ID'")
    private Long rootDocId;

    @ApiModelProperty("来源单据编号")
    @Column(name = "root_doc_no", columnDefinition = "varchar(20) comment '来源单据编号'")
    private String rootDocNo;

    @ApiModelProperty("来源单据类别 [UDC]COM:DOC_CLS")
    @Column(name = "root_doc_cls", columnDefinition = "varchar(200) comment '来源单据类型'")
    private String rootDocCls;

    @ApiModelProperty("质保金尾款")
    @Column(name = "end_amt", columnDefinition = "decimal(20,8) default null  comment '质保金尾款'")
    private BigDecimal endAmt;

}
