package com.elitesland.yst.production.sale.entity;

import com.elitesland.yst.production.sale.core.convert.BigDecimalConvert;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * SAL_RECEIPT_SETTLE(订单收款结算).
 * <p>
 * 订单收款结算
 *
 * @author Evin.dong
 * @date 2021/6/28 15:35
 */
@Entity
@Table(name = "sal_receipt_settle", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "sal_receipt_settle", comment = "订单收款结算")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class SalReceiptSettleDO extends BaseModel implements Serializable {

    @Column(name = "ou_id", columnDefinition = "bigint(18) default 0 comment '公司ID'")
    private Long ouId;

    @Column(name = "ou_code", columnDefinition = "longtext default null  comment '公司编号'")
    private String ouCode;

    @Column(name = "ou_name", columnDefinition = "varchar(200) default null  comment '公司名称'")
    private String ouName;

    @Column(name = "bu_id", columnDefinition = "bigint(18) default null  comment 'BUID'")
    private Long buId;

    @Column(name = "bu_code", columnDefinition = "longtext default null  comment 'BU编号'")
    private String buCode;

    @Column(name = "bu_name", columnDefinition = "varchar(200) default null  comment 'BU名称'")
    private String buName;

    @Column(name = "doc_no", columnDefinition = "varchar(40) default null  comment '单据编号'")
    private String docNo;

    @Column(name = "doc_type", columnDefinition = "longtext default null  comment '结算类型'")
    private String docType;

    @Column(name = "settle_date", columnDefinition = "datetime default null  comment '结算日期'")
    private LocalDateTime settleDate;

    @Column(name = "doc_type2", columnDefinition = "longtext default null  comment '订单类型2 [UDC]SAL:SO_TYPE2'")
    private String docType2;

    @Column(name = "so_source", columnDefinition = "varchar(40) default null  comment '下单渠道 [UDC]SAL:SO_SOURCE'")
    private String soSource;

    @Column(name = "settle_bu_type", columnDefinition = "longtext default null  comment '结算组织类型'")
    private String settleBuType;

    @Column(name = "cust_id", columnDefinition = "bigint(20) default 0 comment '客户ID 售至'")
    private Long custId;

    @Column(name = "cust_code", columnDefinition = "longtext default null  comment '客户编号'")
    private String custCode;

    @Column(name = "cust_name", columnDefinition = "longtext default null  comment '客户名称'")
    private String custName;

    @Column(name = "curr_code", columnDefinition = "longtext default null  comment '币种'")
    private String currCode;

    @Column(name = "agent_emp_id", columnDefinition = "bigint(20) default 0 comment '业务员员工ID'")
    private Long agentEmpId;

    @Column(name = "agent_user_id", columnDefinition = "bigint(20) default 0 comment '业务员用户ID'")
    private Long agentUserId;

    @Column(name = "agent_code", columnDefinition = "longtext default null  comment '业务员编号'")
    private String agentCode;

    @Column(name = "agent_name", columnDefinition = "longtext default null  comment '业务员姓名'")
    private String agentName;

    @Convert(converter = BigDecimalConvert.class)
    @Column(name = "settle_amt", columnDefinition = "decimal(20, 4) default 0  comment '结算总金额'")
    private BigDecimal settleAmt;

    @Convert(converter = BigDecimalConvert.class)
    @Column(name = "settle_tax", columnDefinition = "decimal(20, 4) default 0  comment '结算税额'")
    private BigDecimal settleTax;

    @Column(name = "virtual_flag", columnDefinition = "varchar(256) default null  comment '是否入账'")
    private String virtualFlag;

    @Column(name = "pre_flag", columnDefinition = "varchar(256) default null  comment '是否预收'")
    private String preFlag;

    @Column(name = "receipt_ou_id", columnDefinition = "bigint(10) default 0 comment '收款公司ID'")
    private Long receiptOuId;

    @Column(name = "receipt_ou_code", columnDefinition = "longtext default null  comment '收款公司编号 收款主体'")
    private String receiptOuCode;

    @Column(name = "receipt_ou_name", columnDefinition = "varchar(200) default null  comment '收款公司名称'")
    private String receiptOuName;

    @Column(name = "intf_status", columnDefinition = "longtext default null  comment '接口状态 用于传结算中心'")
    private String intfStatus;

    @Column(name = "intf_time", columnDefinition = "datetime default null  comment '接口时间 用于传结算中心'")
    private LocalDateTime intfTime;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SalReceiptSettleDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SalReceiptSettleDO entity = (SalReceiptSettleDO) o;
        return getId().equals(entity.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }
}
