package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.Data;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import org.hibernate.annotations.Where;

/**
 * @author : WWW
 * @date : 2023-5-19
 * @desc : 销售业绩统计-门店-明细
 */
@Entity
@Table(name="sale_statistics_store_dtl")
@org.hibernate.annotations.Table(appliesTo = "sale_statistics_store_dtl", comment = "销售业绩统计-门店-明细")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class SaleStatisticsStoreDtlDO extends BaseModel {

    /**
     * 关联id
     */
    @Column(name = "mas_id", columnDefinition = "bigint(20) comment '关联id'")
    private Long masId;

    /**
     * 层级：  0——默认是客户所属的业务员  1、2、...——依次往上查询上级赋值
     */
    @Column(name = "level", columnDefinition = "varchar(255) comment '层级：  0——默认是客户所属的业务员  1、2、...——依次往上查询上级赋值'")
    private String level;

    /**
     * 业务员编码
     */
    @Column(name = "code", columnDefinition = "varchar(255) comment '业务员编码'")
    private String code;

    /**
     * 业务员名称
     */
    @Column(name = "name", columnDefinition = "varchar(255) comment '业务员名称'")
    private String name;

    /**
     * 类型
     */
    @Column(name = "type", columnDefinition = "varchar(255) comment '类型'")
    private String type;

    @Column(name = "user_id", columnDefinition = "bigint(20) default null comment '用户id'")
    private Long userId;


}