package com.elitesland.yst.production.sale.repo;

import com.elitesland.yst.production.sale.entity.CrmCustDO;
import com.elitesland.yst.production.sale.entity.SalQuotationDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.transaction.annotation.Transactional;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/6/16 20:09
 */
public interface SalQuotationRepo extends JpaRepository<SalQuotationDO, Long>, QuerydslPredicateExecutor<SalQuotationDO> {

//    @Transactional//事务的注解
//    @Modifying//增删改必须有这个注解
//    @Query(value = "update sal_quotation set quotation_status = ?2, appr_time = ?3, appr_user_id = ?4,appr_comment = ?5 where id = ?1", nativeQuery = true)
//    void approveSalQtotation(Long id, String docStatus, LocalDateTime apprTime,Long apprUserId,String apprComment);


    @Transactional//事务的注解
    @Modifying//增删改必须有这个注解
    @Query(value = "update sal_quotation set quotation_status = ?2 where id = ?1", nativeQuery = true)
    void approveSalQtotation2(Long id, String docStatus);

    @Transactional//事务的注解
    @Modifying//增删改必须有这个注解
    @Query(value = "update SalQuotationDO set quotationStatus = ?2 where id = ?1")
    void updateQuotationStatus(Long id,String status);

    @Transactional//事务的注解
    @Modifying//增删改必须有这个注解
    @Query(value = "update SalQuotationDO set procInstId = ?2 where id = ?1")
    void updateProcInstId(Long id,Long procInstId);
}
