package com.elitesland.yst.production.sale.service;

import com.elitesland.yst.production.sale.Application;
import com.elitesland.yst.production.sale.dto.save.BipOrderRpcDto;
import com.elitescloud.cloudt.common.base.ApiResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

import java.util.List;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/10/07/12:37
 * @Description:
 */
@FeignClient(name = Application.NAME, path = BipOrderRpcService.URI)
public interface BipOrderRpcService {
    String URI = Application.URI_PREFIX + "/order";
    /**
     * 更新明细的物流信息
     * @param bipOrderRpcDtoList
     */
	@PostMapping("/bipOrderRpc/updateOrderLogistInfo")
     ApiResult updateOrderLogistInfo(List<BipOrderRpcDto> bipOrderRpcDtoList);


    /**
     * 更新订单主表状态
     * @param bipOrderRpcDto
     */
	@PostMapping("/bipOrderRpc/updateorderStatus")
    ApiResult updateorderStatus(BipOrderRpcDto bipOrderRpcDto);

    /**
     * 推送栈内消息
     * @param bipShipMentOrderCodes
     * @return
     */
	@PostMapping("/bipOrderRpc/shipMentMessagePush")
    ApiResult shipMentMessagePush(List<String> bipShipMentOrderCodes);

    /**
     * 更新订单发货状态
     * @param orderCodes
     * @return
     */
	@PostMapping("/bipOrderRpc/updateOrderIsSend")
    ApiResult updateOrderIsSend(List<String> orderCodes);
}
