package com.elitesland.yst.production.sale.service;

import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.core.base.UdcProvider;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * @author Danny.Wang
 * @title RmiSysUDCService
 * @Date2023/1/28 15:05
 */
@Slf4j
@Component
public class RmiSysUDCService {

    @Autowired
    private UdcProvider sysUdcService;

    public Map<String, String> getCodeMap(String domain, String udc) {
        try{
            return sysUdcService.getValueMapByUdcCode(domain, udc);
        }catch (Exception e){
            log.error("查询UDC异常:{}", e.getMessage());
            throw new BusinessException(ApiCode.FAIL, "查询UDC信息接口异常");
        }
    }
}
